/*
 * Copyright (C) 1996 Emanuel Borsboom <manny@zerius.victoria.bc.ca>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package sound.zrs.ui;

import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;

public abstract class PropertiesDialog extends JDialog {


    PropertiesObserver observer;


    public PropertiesDialog(
                            String title,
                            PropertiesObserver parent) {
        super();
        setTitle(title);
        observer = parent;
        Panel p = new Panel();
        p.setLayout(new FlowLayout(FlowLayout.RIGHT));
        p.add(new RunButton("ok") {
            public void run() {
                apply();
                observer.hideProperties();
            }
        });
        p.add(new RunButton("Cancel") {
            public void run() {
                observer.hideProperties();
            }
        });
        p.add(new RunButton("Apply") {
            public void run() {
                apply();
            }
        });
        Container c = getContentPane();
        c.add("South", p);
    }


    public void showAndPack() {
        pack();
        super.setVisible(true);
    }

    public abstract void apply();

}
