package sound.spectrogram;

import j2d.ShortImageBean;
import j2d.color.IndexImageBean;
import gui.ClosableJFrame;
import graphics.grapher.*;

import java.awt.*;
import java.awt.image.IndexColorModel;

/**
 * Created by Robert Distinti.
 * User: default
 * Date: Aug 8, 2005
 * Time: 7:40:14 PM
 */
public class mySpectrogramViewer extends ClosableJFrame {

    private GraphComponent graphComponent = new GraphComponent();


    void makeAxis(int npX, double dX, int npY, double dY) {
        double[] dataH = new double[npX * 2];
        double[] dataV = new double[npY * 2];
        int ix = 0;
        int iy = 1;
        for (int i = 0; i < npX; i++) {
            dataH[ix] = i*dX;
            dataH[iy] = i;
            ix = ix + 2;
            iy = iy + 2;
        }
        ix = 0;
        iy = 1;
        for (int i = 0; i < npY; i++) {
            dataV[ix] = i;
            dataV[iy] = i*dY/1000;
            ix = ix + 2;
            iy = iy + 2;
        }
        graphComponent.setBackground(Color.white);
        DataSet dataSetH;
        dataSetH = graphComponent.loadDataSet(dataH, npX);
        dataSetH.linecolor = new Color(0, 0, 0);
        dataSetH.legendColor(new Color(0, 0, 0));
        DataSet dataSetV = graphComponent.loadDataSet(dataV, npY);
        dataSetV.linecolor = new Color(0, 0, 0);
        dataSetV.legendColor(new Color(0, 0, 0));

        //xaxis = graphComponent.createAxis(Axis.TOP);
        //xaxis.attachDataSet(dataSet);
        // xaxis.title = dl.x_label;

        Axis xaxis = graphComponent.createAxis(Axis.BOTTOM);
        xaxis.attachDataSet(dataSetH);
        xaxis.title = new TextLine("seconds");

        Axis yaxis = graphComponent.createAxis(Axis.RIGHT);
        yaxis.attachDataSet(dataSetV);
        yaxis.title = new TextLine("Khz");

    }
    public void setImageData(Image img){
        graphComponent.setImageData(img);
    }
    private void initialize() {
        addComponent("Center", graphComponent);
        setSize(250, 250);
        setVisible(true);
    }

    public void draw() {
        repaint();
    }

    private IndexColorModel getIndexColorModel(){
        int n = 256;
        byte[] reds = new byte[n];
        byte[] greens = new byte[n];
        byte[] blues = new byte[n];
        int nleg=255/5;
        double dc=255.0/nleg;
        double r=0;
        double g=0;
        double b=0;
        int idx=0;
        // up the blue
        for (int i=0; i<nleg; i++){
            reds[idx]=(byte)r;
            greens[idx]=(byte)g;
            blues[idx]=(byte)b;
            idx++;
            b+=dc;
        }
        // down to green
        for (int i=0; i<nleg; i++){
            reds[idx]=(byte)r;
            greens[idx]=(byte)g;
            blues[idx]=(byte)b;
            idx++;
            b-=dc;
            g+=dc;
        }
        // over to yellow
        for (int i=0; i<nleg; i++){
            reds[idx]=(byte)r;
            greens[idx]=(byte)g;
            blues[idx]=(byte)b;
            idx++;
            r+=dc;
        }
        // over to red
        for (int i=0; i<nleg; i++){
            reds[idx]=(byte)r;
            greens[idx]=(byte)g;
            blues[idx]=(byte)b;
            idx++;
            g-=dc;
            r+=dc;
        }
        // to white
        for (int i=0; i<nleg; i++){
            reds[idx]=(byte)r;
            greens[idx]=(byte)g;
            blues[idx]=(byte)b;
            idx++;
            b+=dc;
            g+=dc;
        }

        // last is white
        reds[idx]=(byte)255;
        greens[idx]=(byte)255;
        blues[idx]=(byte)255;
        return new IndexColorModel(8, n, reds, greens, blues);
    }


    public mySpectrogramViewer(String title,SpectroGramContainer scont, boolean logdisplay){
        super(title);
        initialize();
        int npH=scont.getNumX();
        int npV=scont.getNumY();
        double spH=scont.getSecondsPerX();
        double fpV=scont.getFrequencyPerY();
        makeAxis(npH,spH,npV,fpV);

        ShortImageBean myBlue=new  ShortImageBean(npH,npV);
        if(logdisplay){
            myBlue.setB(scont.getLogScaledData((short)255));
            super.setTitle(title+" LogScaled");
        }else{
            myBlue.setB(scont.getScaledData((short)255));
        }
        IndexImageBean myIndexBean=new IndexImageBean(myBlue);
        myIndexBean.setIndexColorModel( getIndexColorModel());
        setImageData(myIndexBean.getImage());
        draw();

    }
}
