package sound.spectrogram;

/**
 * Created by Robert Distinti.
 * User: default
 * Date: Aug 8, 2005
 * Time: 9:47:58 PM
 */
public class SpectroGramContainer {
    private double data[][];    //[x][y]
    private double max;
    private double min;
    private double minNonZero;
    private int numX;
    private int numY;
    private double secondsPerX;
    private double frequencyPerY;

    public void setData(double newdata[][], double secPerX, double freqPerY) {
        numX = newdata.length;
        numY = newdata[0].length;
        data = new double[numX][numY];
        min = 1e300;
        max = -min;
        minNonZero = min;
        double z;
        for (int x = 0; x < numX; x++) {
            for (int y = 0; y < numY; y++) {
                z = newdata[x][y];
                if (z > max) max = z;
                if (z < min) min = z;
                if (z > 0 && z < minNonZero) {
                    minNonZero = z;
                }
                data[x][y] = z;
            }
        }
        secondsPerX = secPerX;
        frequencyPerY = freqPerY;
    }

    public int getNumX() {
        return numX;
    }

    ;

    public int getNumY() {
        return numY;
    }

    ;

    public double getMin() {
        return min;
    }

    ;

    public double getMax() {
        return max;
    }

    ;

    public double getSecondsPerX() {
        return secondsPerX;
    }

    public double getFrequencyPerY() {
        return frequencyPerY;
    }


    public short[][] getScaledData(short scaleMaxToThis) {
        double scale = (double) scaleMaxToThis / max;
        short rtn[][] = new short[numX][numY];
        for (int x = 0; x < numX; x++) {
            for (int y = 0; y < numY; y++) {
                rtn[x][y] = (short) (data[x][y] * scale);
            }
        }
        return rtn;
    }

    public short[][] getLogScaledData(short scaleMaxToThis) {
        double maxLog = Math.log(max / minNonZero);       // gets mapped to max int
        double scale = (double) scaleMaxToThis / maxLog;
        short rtn[][] = new short[numX][numY];
        for (int x = 0; x < numX; x++) {
            for (int y = 0; y < numY; y++) {
                double z = data[x][y];
                if (z > 0) {
                    z = Math.log(z / minNonZero) * scale;
                }
                if (z < 0) {
                    System.out.println("less than zero vlue detected");
                    z = 0;
                }
                rtn[x][y] = (short) z;
            }
        }
        return rtn;
    }

    public SpectroGramContainer(double newdata[][], double secPerX, double freqPerY) {
        setData(newdata, secPerX, freqPerY);
    }
}
