/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Sep 29, 2003
 * Time: 8:53:01 PM
 * To change this template use Options | File Templates.
 */
package sound.soundDemo;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;

/**
 * Piano renders black & white keys and plays the notes for a MIDI
 * channel.
 */
class OuterPiano extends JPanel implements MouseListener {

    Vector blackKeys = new Vector();
    Key prevKey;
    final int kw = 16, kh = 80;
    private MidiSynth midiSynth;

    public OuterPiano(final MidiSynth midiSynth) {
        this.midiSynth = midiSynth;
        midiSynth.setLayout(new BorderLayout());
        midiSynth.setPreferredSize(new Dimension(42 * kw, kh + 1));
        int transpose = 24;
        int whiteIDs[] = {0, 2, 4, 5, 7, 9, 11};

        for (int i = 0, x = 0; i < 6; i++) {
            for (int j = 0; j < 7; j++, x += kw) {
                int keyNum = i * 12 + whiteIDs[j] + transpose;
                Key k = new Key(midiSynth, x, 0, kw, kh, keyNum);
                midiSynth.whiteKeys.add(k);
            }
        }
        for (int i = 0, x = 0; i < 6; i++, x += kw) {
            int keyNum = i * 12 + transpose;
            blackKeys.add(new Key(midiSynth, (x += kw) - 4, 0, kw / 2, kh / 2, keyNum + 1));
            blackKeys.add(new Key(midiSynth, (x += kw) - 4, 0, kw / 2, kh / 2, keyNum + 3));
            x += kw;
            blackKeys.add(new Key(midiSynth, (x += kw) - 4, 0, kw / 2, kh / 2, keyNum + 6));
            blackKeys.add(new Key(midiSynth, (x += kw) - 4, 0, kw / 2, kh / 2, keyNum + 8));
            blackKeys.add(new Key(midiSynth, (x += kw) - 4, 0, kw / 2, kh / 2, keyNum + 10));
        }
        midiSynth.keys.addAll(blackKeys);
        midiSynth.keys.addAll(midiSynth.whiteKeys);

        midiSynth.addMouseMotionListener(new MouseMotionAdapter() {
            public void mouseMoved(MouseEvent e) {
                if (midiSynth.mouseOverCB.isSelected()) {
                    Key key = getKey(e.getPoint());
                    if (prevKey != null && prevKey != key) {
                        prevKey.off();
                    }
                    if (key != null && prevKey != key) {
                        key.on();
                    }
                    prevKey = key;
                    midiSynth.repaint();
                }
            }
        });
        midiSynth.addMouseListener(this);
    }

    public void mousePressed(MouseEvent e) {
        prevKey = getKey(e.getPoint());
        if (prevKey != null) {
            prevKey.on();
            midiSynth.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (prevKey != null) {
            prevKey.off();
            midiSynth.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (prevKey != null) {
            prevKey.off();
            midiSynth.repaint();
            prevKey = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }


    public Key getKey(Point point) {
        for (int i = 0; i < midiSynth.keys.size(); i++) {
            if (((Key) midiSynth.keys.get(i)).contains(point)) {
                return (Key) midiSynth.keys.get(i);
            }
        }
        return null;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        Dimension d = midiSynth.getSize();

        g2.setBackground(midiSynth.getBackground());
        g2.clearRect(0, 0, d.width, d.height);

        g2.setColor(Color.white);
        g2.fillRect(0, 0, 42 * kw, kh);

        drawWhiteKeys(g2);
        drawBlackKeys(g2);
    }

    private void drawWhiteKeys(Graphics2D g2) {
        for (int i = 0; i < midiSynth.whiteKeys.size(); i++) {
            Key key = (Key) midiSynth.whiteKeys.get(i);
            if (key.isNoteOn())
                drawWhiteKeyOn(g2, key);
            drawWhiteKeyOff(g2, key);
        }
    }

    private void drawWhiteKeyOff(Graphics2D g2, Key key) {
        g2.setColor(Color.black);
        g2.draw(key);
    }

    private void drawWhiteKeyOn(Graphics2D g2, Key key) {
        Color c = midiSynth.record ? midiSynth.pink : midiSynth.jfcBlue;
        g2.setColor(c);
        g2.fill(key);
    }

    private void drawBlackKeys(Graphics2D g2) {
        for (int i = 0; i < blackKeys.size(); i++) {
            Key key = (Key) blackKeys.get(i);
            if (key.isNoteOn())
                drawKeyOn(g2, key);
            else
                drawKeyOff(g2, key);
        }
    }

    private void drawKeyOff(Graphics2D g2, Key key) {
        g2.setColor(Color.black);
        g2.fill(key);
    }

    private void drawKeyOn(Graphics2D g2, Key key) {
        g2.setColor(midiSynth.record ? midiSynth.pink : midiSynth.jfcBlue);
        g2.fill(key);
        g2.setColor(Color.black);
        g2.draw(key);
    }
} // End class Piano
