package sound.recorder;

import net.multicast.McastUtil;

import javax.sound.sampled.LineUnavailableException;
import java.io.IOException;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Dec 6, 2004
 * Time: 2:37:32 PM
 */
public class StreamingAudioMulticastRcvr
        extends Thread implements Runnable {
    public static final int PORT = 4321;
    private McastUtil mcu = new McastUtil(PORT);

    public static void main(String[] args) {
        StreamingAudioMulticastRcvr
                s = new StreamingAudioMulticastRcvr();
        s.start();
    }

    private byte[] getDataGram() {
        try {
            return mcu.getBytes();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public StreamingAudioMulticastRcvr() {
        mcu.enableLoopBack();
    }

    public void run() {
        try {
            readAndPlayLoop();
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    private void readAndPlayLoop() throws InterruptedException, LineUnavailableException {
        byte[] b;
        while (true) {
            b = getDataGram();
            if (b == null) {
                sleep(1);
                continue;
            }
            if (b.length < 0){
                sleep(1);
                continue;
            }
            PlayThread.playAudioData(b);
        }
    }
}
