package sound.musica;




public class SongReader {


    public static final int BLACK_ORPHEUS[] = {
        8, 4, 3, 1, 1, 12, 3, 8, 8, 4, 3, 1, 1, 11, 3,
        8, 8, 9, 11, 2, 6, 6, 6, 8, 9, 11, 4, 4, 4,
        6, 8, 9, 3, 3, 4, 6, 8, 8, 4, 3,
        1, 1, 12, 3, 8, 8, 2, 1, 11, 11, 9, 8, 1, 6, 6, 8, 9, 11, 4, 4, 6, 8, 1,
        12, 8, 8, 12, 3, 1, 8, 1, 1,
        3, 4, 6, 4, 3, 1, 3, 4, 6, 4, 3, 1, 3, 4, 6, 4, 3, 1, 11
    };

    public PetriNodes buildMarkov(int events[], int order) {
        PetriNodes pn = new PetriNodes();
        for (int i = 0; i < events.length; i++) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < order; j++) {
                int eventIndex = i + j;
                if (eventIndex >= events.length) continue;
                sb.append(events[eventIndex] + ":");
            }
            pn.add(new PetriNode(sb.toString()));
        }
        return pn;
    }

    public static final int BLACK_ORPHEUS_NOTES[] =
            sound.SoundUtils.transpose(BLACK_ORPHEUS, 64);
    private static int i;

    public static int getNextNote() {
        return BLACK_ORPHEUS_NOTES[i++ % BLACK_ORPHEUS_NOTES.length];
    }

    public static PetriNodes initMarkov(int order) {
        SongReader sr = new SongReader();
        PetriNodes pn = sr.buildMarkov(SongReader.BLACK_ORPHEUS_NOTES, order);
        pn.init();
        return pn;
    }

    public static void main(String args[]) {
        PetriNodes pn = initMarkov(3);
        for (int i = 0; i < 9; i++)
            (pn.getNode(i)).play();
    }


}