/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package sound.dialTones;

import gui.In;
import gui.run.DialBean;
import sound.Oscillator;

import javax.sound.sampled.LineUnavailableException;
import java.io.IOException;

public class DTMF {
    private int frequency1 = 0;
    private int frequency2 = 0;
    private long duration = 62; // in ms


    public DTMF(int f1, int f2, DialBean db) {
        duration = db.getSpeed();
        frequency1 = f1;
        frequency2 = f2;
        if (f1 ==0 && f2==0)  {
            duration = 1000;
        }
        if (f1<0||f2<0){
            frequency1=0;
            frequency2=0;
            duration = 0;
        }
    }

    public void play() {
        if (frequency1 < 0) return;
        if (frequency1 == 0){
            try {
                Thread.sleep(duration*2);
            } catch (InterruptedException e) {
            }
            return;
        }
        try {
            Oscillator.playLinearData(
                    Oscillator.getSineWave(frequency1, frequency2, duration));
        } catch (LineUnavailableException e) {
            In.message(e);

        } catch (IOException e) {
            In.message(e);

        }

    }

    public int getFrequency1() {
        return frequency1;
    }

    public void setFrequency1(int frequency1) {
        this.frequency1 = frequency1;
    }

    public int getFrequency2() {
        return frequency2;
    }

    public void setFrequency2(int frequency2) {
        this.frequency2 = frequency2;
    }

    public long getDuration() {
        return duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public static void main(String[] args) {
        ToneMap tm = new ToneMap();
        DTMF d = tm.getDtmf('1');
        d.play();
    }
}
