package serialPort.test;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;

import java.util.Enumeration;

public class OpenCloseTest {
    public static void main(String args[]) {
        openCloseTest();
    }
    public static void openCloseTest() {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId =
                    (CommPortIdentifier) portList.nextElement();
            final String name = portId.getName();
            System.out.println(name+":attempting open-close");
            try {
                openCloseTest(portId);
            } catch (PortInUseException e) {
                System.out.println(name+":PortInUseException");

            }
        }
    }
    public static void openCloseTest(CommPortIdentifier portId)
            throws PortInUseException {
        final String name = portId.getName();
        SerialPort serialPort =
                (SerialPort) portId.open(name, 200);
        serialPort.close();
        System.out.println(name+":worked!");
    }
}

