/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package security;

import futils.Futil;
import gui.In;
import utils.SystemUtils;

import java.io.File;
import java.io.IOException;



/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Feb 13, 2005
 * <p/>
 * Time: 6:15:37 AM
 */
public class WebStartLauncher {
    public static void main(String[] args) {
        String answerDest = "book/cgij/code/jnlp/";
        String jobDirectory = "http://show.docjava.com:8086/" +
                        answerDest;
        String webStartUrl = jobDirectory +
                "net.rmi.rjs.fc.FractalsJob_6.jnlp";
        // we need a URL scanner that runs on the LUS and
        // looks for jobs.

        File answer = startWebstartAndWaitForAnswer(webStartUrl);
        System.out.println("I have an answer!" +
                answerDest+
                answer.getName());
        // we also need a way to rename the answer.
        // Now we need a way to xmit the answer back to the cs.
    }


    /**
     * Start web start on the given url, then kill the process, to showAndRegister we
     * have control over stopping and starting a process.
     * You must call exit in your web start application or this
     * code will NEVER FINISH.
     * The Correct way to do this is to monitor a directory
     * that contains the output and upload it after it is
     * done writing.
     */
    public static void startWebStart() {
        File webStart = getWebstartLocation();
        String args[] = {
            webStart.toString(),
            "-wait",
            "http://show.docjava.com:8086/book/cgij/code/jnlp/net.rmi.rjs.fc.FractalsJob_1.jnlp"
            //"http://show.docjava.com:8086/book/cgij/code/jnlp/dhry.Main.jnlp"
        };
        try {
            File f = new File(SystemUtils.getUserHome() + SystemUtils.getDirectorySeparator() +
                    "Fractals_out1.ppm.jar");
            f.delete();
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(args, null, null);
            try {
                int status = p.waitFor();
                System.out.println("status=" + status);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            System.out.println(f + ":f can write=" + f.canWrite());
            f.delete();
        } catch (IOException e) {
            e.printStackTrace();
        }


    }

    /**
     * Start web start on the given url, then kill the process, to showAndRegister we
     * have control over stopping and starting a process.
     * You must call exit in your web start application or this
     * code will NEVER FINISH.
     * The Correct way to do this is to monitor a directory
     * that contains the output and upload it after it is
     * done writing.
     */
    public static File startWebstartAndWaitForAnswer(String webStartUrl) {
        String ds = SystemUtils.getUserHome() + SystemUtils.getDirectorySeparator() +
                "rjs" + SystemUtils.getDirectorySeparator();
        File answerDir = new File(ds);
        if (!answerDir.exists()) answerDir.mkdir();
        File webStart = getWebstartLocation();

        String args[] = {
            webStart.toString(),
            webStartUrl
            //"http://show.docjava.com:8086/book/cgij/code/jnlp/dhry.Main.jnlp"
        };
        try {

            Runtime rt = Runtime.getRuntime();
            rt.exec(args, null, null);
            File answer = waitForAnswer(answerDir);
            System.out.println("got an answer:" + answer);
            return answer;
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    private static File waitForAnswer(File answerDir) {
        while (true) {
            File l[] = answerDir.listFiles();
            if (l == null || l.length == 0) {

                sleepASec();
                continue;
            } else if (l[0].canWrite()) return l[0];
            sleepASec();
        }
    }

    
    private static void sleepASec() {
        try {
            System.out.println("sleeping");
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /**
     * Search for the Java web start application. If you cannot find it,
     * prompt the user. In the future, there should be a better way to do
     * this, but what, I don't know. And what if javaws cannot be found
     * because it is not installed? Tricky!
     *
     * @return the java webstart file.
     */
    public static File getWebstartLocation() {
        System.out.println(SystemUtils.getJavaHome());
        String s = SystemUtils.getDirectorySeparator();
        // check widows location:
        File f = new File(SystemUtils.getJavaHome() +
                s +
                "bin" +
                s +
                "javaws.exe");
        if (f.exists()) return f;
        // check mac location:
        final String wsMacLocation = "/" +
                        "Applications" +
                        s +
                        "Utilities" +
                        s +
                        "Java" +
                        s +
                        "Java Web Start.app" +
                        s +
                        "Contents" +
                        s +
                        "MacOS" +
                        s +
                        "Java Web Start";
        f = new File(wsMacLocation);
        if (f.exists()) return f;
        // check linux location for jdk1.5:
        f = new File("" +
                s +
                "usr" +
                s +
                "java" +
                s +
                "j2sdk1.5.0" +
                s +
                "bin" +
                s +
                "javaws");
        if (f.exists()) return f;
        f =
                Futil.getReadFile("could not find javaws, please help me locate it");
        if (f == null) {
            In.message("user canceled operation, program terminates");
            System.exit(0);
        }
        String cn = "security.WebstartUtils";
        System.out.println("please add:" + f + " to" + cn);
        return f;
    }
}
