package security;

import gui.In;

import javax.crypto.KeyGenerator;
import java.security.*;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * User: dlyon
 * Date: Oct 5, 2005
 * Time: 4:53:41 PM
 */
public class SecurityUtils {
    public static void main(String[] args) {
        String[] serviceTypes = getServiceTypes();
        System.out.println("-----Service Types-------");
        print(serviceTypes);
        for (int i = 0; i < serviceTypes.length; i++) {
            String serviceType = serviceTypes[i];
            System.out.println("----" + serviceType + ':' + "-------");
            print(getCryptoImpls(serviceType));
        }
        System.out.println("------key pair generators----------");
        print(getKeyPairGenerators());
        System.out.println("------signature algorithms-------------");
        print(getSignatureAlgorithms());
        System.out.println("------KeyGenerator algorithms-------------");
        print(getKeyGenerators());
        System.out.println("------Cryptographic Services-------------");
        print(getCryptographicServices());
    }

    public static String[] getCryptographicServices() {
        return getCryptoImpls("Cipher");
    }

    public static String[] getKeyGenerators() {
        return getCryptoImpls("KeyGenerator");
    }

    public static String[] getSignatureAlgorithms() {
        return getCryptoImpls("Signature");
    }

    public static String[] getKeyPairGenerators() {
        return getCryptoImpls("KeyPairGenerator");

    }

    private static void print(String[] serviceTypes) {
        for (int i = 0; i < serviceTypes.length; i++)
            System.out.println(serviceTypes[i]);
    }

    public static String[] getServiceTypes() {
        Set result = new HashSet();

        // All all providers
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; i++) {
            // Get services provided by each provider
            Set keys = providers[i].keySet();
            for (Iterator it = keys.iterator(); it.hasNext();) {
                String key = (String) it.next();
                key = key.split(" ")[0];

                if (key.startsWith("Alg.Alias.")) {
                    // Strip the alias
                    key = key.substring(10);
                }
                int ix = key.indexOf('.');
                result.add(key.substring(0, ix));
            }
        }
        return (String[]) result.toArray(new String[result.size()]);
    }

    // This method returns the available implementations for a service type
    public static String[] getCryptoImpls(String serviceType) {
        Set result = new HashSet();

        // All all providers
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; i++) {
            // Get services provided by each provider
            Set keys = providers[i].keySet();
            for (Iterator it = keys.iterator(); it.hasNext();) {
                String key = (String) it.next();
                key = key.split(" ")[0];

                if (key.startsWith(serviceType + ".")) {
                    result.add(key.substring(serviceType.length() + 1));
                } else if (key.startsWith("Alg.Alias." + serviceType + ".")) {
                    // This is an alias
                    result.add(key.substring(serviceType.length() + 11));
                }
            }
        }
        return (String[]) result.toArray(new String[result.size()]);
    }


    public static Key getKey(String uidPw) throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("DES");
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(uidPw.hashCode());
        generator.init(secureRandom);
        return generator.generateKey();
    }

    public static String getUidPw() {
        String uid = In.getString("enter uid");
        if (uid==null) return null;
        String pw = In.getPassword("enter pw");
        if (pw==null) return null;
        String concat = uid + pw;
        concat = concat.toLowerCase();
        return concat;
    }
}
