package security;

import gui.In;
import sun.misc.BASE64Decoder;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;

public class SecureWritingGui {
    public static void main(String[] args) throws Exception {
        String concat = SecurityUtils.getUidPw();
        System.out.println(concat);


        Key key = SecurityUtils.getKey(concat);

        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        String plainText = In.getString("enter string to encode");
        String codeText = encode(cipher, key, plainText);
        System.out.println("codeText:" + codeText);
        decode(cipher, key, codeText);
    }

    private static void decode(Cipher cipher, Key key, String codeText) throws InvalidKeyException,
            IOException, IllegalBlockSizeException, BadPaddingException {

        cipher.init(Cipher.DECRYPT_MODE, key);
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] raw = decoder.decodeBuffer(codeText);
        byte[] stringBytes = cipher.doFinal(raw);
        String result = new String(stringBytes, "UTF8");
        System.out.println(result);
    }

    private static String encode(Cipher cipher, Key key, String plainText)
            throws InvalidKeyException,
            UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        cipher.init(Cipher.ENCRYPT_MODE, key);
        byte[] stringBytes = plainText.getBytes("UTF8");
        byte[] raw = cipher.doFinal(stringBytes);
        security.BASE64Encoder encoder = new security.BASE64Encoder();
        String base64 = encoder.encode(raw);
        return base64;
    }

}
