/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package security;


import gui.ClosableJFrame;
import gui.layouts.DialogLayout;
import gui.run.RunCheckBox;

import javax.swing.*;
import java.awt.*;


public abstract class RunJnlpPanel
        extends JPanel implements Runnable {

    private JnlpBean b = JnlpBean.restore();


    public RunJnlpPanel() {

        init();
    }

    private void init() {
        setLayout(new BorderLayout());
        add(getPropPanel(), BorderLayout.CENTER);

    }

    private JPanel getPropPanel() {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createTitledBorder("Jnlp Props"));
        jp.setLayout(new DialogLayout());
        jp.add(new JLabel(" upload"));

        jp.add(
                new RunCheckBox(b.isUploadJnlpFile()) {
                    public void run() {
                        b.setUploadJnlpFile(isSelected());
                        updateListeners();
                    }
                });
        //jarGui(jp);

        return jp;
    }

    private void updateListeners() {
        b.save();
        run();

    }

    public JnlpBean getValue() {
        return b;
    }


    public static void main(String[] args) {
        final ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(
                new RunJnlpPanel() {
                    public void run() {
                        System.out.println(getValue());
                        cf.pack();
                    }
                });
        cf.pack();
        cf.setVisible(true);
    }


}