package security;

// security.Initium

import classUtils.pack.PackUtils;
import gui.In;
import utils.SystemUtils;

import java.io.File;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 4, 2004
 * <p/>
 * Time: 6:40:02 PM
 */
public class Initium {
    public static void main(String[] args) {

        try {
            do
                packSignAndUpload();
            while (In.getBoolean("go again?"));
            System.exit(0);
        } catch (Exception e) {
            In.message(e);
            if (In.getBoolean("try again?"))
                main(null);
            System.exit(0);
        }
    }

    /**
     * All defaults now in a <code>WebStartBean</code> with a confirming
     * dialog. However, the defaults never change.
     */
    public static void packSignAndUpload() throws Exception {
        WebStartBean wsb = WebStartBean.getFromPreferences();
        InitiumDialog id = new InitiumDialog(wsb);
        id.setVisible(true);
        long t = System.currentTimeMillis();
        wsb = id.getWebStartBean();
        wsb.save();
        if (wsb.isValid())
            packSignAndUpload(wsb,id.getJnlpBean());
        t= System.currentTimeMillis()-t;
        System.out.println("Processing took:"+t/1000.0+" seconds");
    }

    public static void packSignAndUpload(
            WebStartBean wsb, JnlpBean jnlpBean)
            throws Exception {
        packSignAndUpload(wsb.getClassName(),
                new File(wsb.getJarFileName()),
                new File(wsb.getKeyStoreFile()),
                wsb.getPassword(),
                wsb.getAlias(),
                wsb.getVendor(),
                wsb.getHostUrl(),
                wsb.getCodeBase(),
                wsb.getIconUrl(),
                wsb.getWebServerUid(),
                wsb.getWebServer(),
                wsb.getRootDirectory(),
                jnlpBean);
    }

    public static void packSignAndUpload(
            final String mainClassName,
            File targetJarFile,
            final File keyStoreFile,
            final String password,
            final String alias,
            String vendor,
            String url,
            String codeBase,
            String iconUrl,
            String user,
            String webServer,
            final String rootDirectory,
            JnlpBean jnlpBean)
            throws Exception {

        PackUtils.pack(mainClassName,
                targetJarFile);
        System.out.println("packing done...now signing...");
        SignUtils.sign(keyStoreFile + "",
                password,
                targetJarFile,
                alias);
        String localCodeBase = keyStoreFile.getParent();
        String separator = SystemUtils.getDirectorySeparator();

        final File jnlpFile = new File(localCodeBase +
                separator +
                mainClassName +
                ".jnlp");
        System.out.println("now uploading...");
        //todo assume that the keystore password and the
        // web server password are the same.
        // what happens if they are not?
        // We should handle that case.
        WebStartUtils.uploadJarAndJnlp(mainClassName,
                vendor,
                url,
                targetJarFile,
                mainClassName,
                jnlpFile,
                codeBase,
                iconUrl,
                user,
                webServer,
                rootDirectory,
                jnlpBean);
    }
}
