package security;

import javax.crypto.*;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Oct 5, 2005
 * Time: 5:24:04 PM
 */
public class DesEncrypter {
    Cipher ecipher;
    Cipher dcipher;
// 8-byte Salt
    byte[] salt = {
            (byte) 0xA9, (byte) 0x9B, (byte) 0xC8, (byte) 0x32,
            (byte) 0x56, (byte) 0x35, (byte) 0xE3, (byte) 0x03
    };

    // Iteration count
    int iterationCount = 19;

    public DesEncrypter(String passPhrase) {
        try {
            // Create the key
            KeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance(
                    "PBEWithMD5AndDES").generateSecret(keySpec);
            ecipher = Cipher.getInstance(key.getAlgorithm());
            dcipher = Cipher.getInstance(key.getAlgorithm());

            // Prepare the parameter to the ciphers
            AlgorithmParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);

            // Create the ciphers
            ecipher.init(Cipher.ENCRYPT_MODE, key, paramSpec);
            dcipher.init(Cipher.DECRYPT_MODE, key, paramSpec);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DesEncrypter(SecretKey key) {
        try {
            ecipher = Cipher.getInstance("DES");
            dcipher = Cipher.getInstance("DES");
            ecipher.init(Cipher.ENCRYPT_MODE, key);
            dcipher.init(Cipher.DECRYPT_MODE, key);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testObjectEncoder() {
        try {
            // Generate a temporary key. In practice, you would save this key.
            SecretKey key = KeyGenerator.getInstance("DES").generateKey();

            // Prepare the encrypter
            Cipher ecipher = Cipher.getInstance("DES");
            ecipher.init(Cipher.ENCRYPT_MODE, key);

            // Seal (encrypt) the object
            SealedObject so = new SealedObject(new MySecretClass(), ecipher);

            // Get the algorithm used to seal the object
            String algoName = so.getAlgorithm();  // DES

            // Prepare the decrypter
            Cipher dcipher = Cipher.getInstance("DES");
            dcipher.init(Cipher.DECRYPT_MODE, key);

            // Unseal (decrypt) the class
            MySecretClass o = (MySecretClass) so.getObject(dcipher);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class MySecretClass implements java.io.Serializable {
        String s = "the secret";
    }


    public static void main(String[] args) {
        try {
            testDesEncryptionWithGeneratedKey();
            testPassPhraseEncryption();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private static void testDesEncryptionWithGeneratedKey() throws NoSuchAlgorithmException {
        // Generate a temporary key. In practice, you would save this key.
        SecretKey key = KeyGenerator.getInstance("DES").generateKey();

        // Create encrypter/decrypter class
        DesEncrypter encrypter = new DesEncrypter(key);

        // Encrypt
        String encrypted = encrypter.encrypt("Don't tell anybody!");
        System.out.println("code text:" + encrypted);
        // Decrypt
        String decrypted = encrypter.decrypt(encrypted);
        System.out.println("clear text:" + decrypted);
    }

    public String encrypt(String str) {
        try {
            // Encode the string into bytes using utf-8
            byte[] utf8 = str.getBytes("UTF8");

            // Encrypt
            byte[] enc = ecipher.doFinal(utf8);

            // Encode bytes to base64 to get a string
            return new sun.misc.BASE64Encoder().encode(enc);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void testPassPhraseEncryption() {
        // Create encrypter/decrypter class
        DesEncrypter encrypter = new DesEncrypter("My Pass Phrase!");

        // Encrypt
        String encrypted = encrypter.encrypt("Don't tell anybody!");
        System.out.println("code:" + encrypted);
        // Decrypt
        String decrypted = encrypter.decrypt(encrypted);
        System.out.println("clear:" + decrypted);
    }


    public String decrypt(String str) {
        try {
            // Decode base64 to get bytes
            byte[] dec = new sun.misc.BASE64Decoder().decodeBuffer(str);

            // Decrypt
            byte[] utf8 = dcipher.doFinal(dec);

            // Decode using utf-8
            return new String(utf8, "UTF8");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
