package security;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Oct 18, 2005
 * Time: 3:49:09 PM
 */
public class CipherBean implements Serializable {
    private Cipher cipher;
    private Key key;

    public CipherBean(String uidPw) throws InvalidKeyException,
            NoSuchAlgorithmException, NoSuchPaddingException {
        cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        key = SecurityUtils.getKey(uidPw);
    }

    public Cipher getEncoder() throws InvalidKeyException {
        cipher.init(Cipher.ENCRYPT_MODE, key);
        return cipher;
    }

    public Cipher getDecoder() throws InvalidKeyException {
        cipher.init(Cipher.DECRYPT_MODE, key);
        return cipher;
    }

    public static void main(String[] args) {
        try {
            CipherBean cb = new CipherBean("fooBar");
            Cipher c = cb.getEncoder();
            cb.getDecoder();
        } catch (InvalidKeyException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
    }


    public Key getKey() {
        return key;
    }

}
