//============================================================================
// Edward Thompson
// 10/16/2005
//
// Homework Assignment 4
//          CR320
//
// Utils
//      Utility class to generate a dialog box that allows a user to create
//  or modify a list of stock tickers.  Will check the ticker's validity upon
//  entry
//============================================================================
package net.stocks.stockViewer;

import gui.layouts.VerticalLayout;
import gui.run.RunButton;
import gui.run.RunList;
import gui.run.RunTextField;
import net.web.UrlUtils;

import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.util.Vector;

/**
 * Created by IntelliJ IDEA.
 * User: Cool Ed
 * Date: Oct 9, 2005
 * Time: 4:58:02 PM
 * To change this template use File | Settings | File Templates.
 */
public class Utils {
    private static JDialog jd = null;

    private static Vector stockList = null;//growable list of ticker strings
    private static int selectedTickerElement = -1;

    private static RunTextField tickerInput;
    private static RunList stockRunList;

    private Utils()//don't need an instance of this class
    {
    }

    //***********************************************************************
    // Static methods to manipulate the internal copy of stock tickers
    //***********************************************************************
    private static void setStockTickerList(Vector tickers) {
        stockList = (Vector) tickers.clone();
    }

    private static void addStockTicker(String stockName) {
        stockList.addElement(stockName);
    }

    private static void removeStockTicker(int index) {
        stockList.removeElementAt(index);
    }

    private static void clearStockList() {
        stockList.clear();
    }

    //***********************************************************************
    // addTicker uses checkTickerValid to determine if the specified ticker
    // is valid - displays a notification JOptionPane if not
    //***********************************************************************
    public static void addTicker(String ticker) {
        if (checkTickerValid(ticker)) {
            addStockTicker(ticker);
            tickerInput.setText("");
        } else {
            String err = "'" + ticker + "' is not a valid ticker symbol";

            JOptionPane.showMessageDialog(jd,
                    err,
                    "Invalid symbol",
                    JOptionPane.ERROR_MESSAGE
            );
        }
    }

    //***********************************************************************
    // checkTickerValid will determine if a specified ticker is valid
    // by querying the finances.yahoo.com website, and searching the
    // html of the page for strings that will say the ticker is not
    // valid
    //***********************************************************************
    private static boolean checkTickerValid(String ticker) {
        String tickerCheckString = buildTickerSearchString(ticker);
        Vector tickerPage = UrlUtils.getUrlVector(tickerCheckString);

        String temp;

        for (int i = 0; i < tickerPage.size(); i++) {
            temp = (String) tickerPage.elementAt(i);

            if (temp.indexOf("is not a valid ticker symbol") != -1) {
                return false;
            } else if (temp.indexOf("Error: Please enter a ticker symbol.") != -1) {
                return false;
            }
        }

        return true;
    }

    private static String buildTickerSearchString(String ticker) {
        return "http://finance.yahoo.com/q/op?s=" + ticker;
    }

    //***********************************************************************
    //this method will display a window containing the list of stocks
    //can then add, delete or clear the list
    // this dialog box is modal, and will return the vector of strings
    // to the calling method when done is clicked
    //***********************************************************************
    public static Vector createStockListWindow(Vector tickers, JFrame daddy) {
        setStockTickerList(tickers);

        jd = new JDialog(daddy, "Change Stocks", true);
        Container c = jd.getContentPane();
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BorderLayout());
        inputPanel.add(makeTickerEntry(), BorderLayout.NORTH);
        inputPanel.add(makeStockListWindow(stockList), BorderLayout.CENTER);
        inputPanel.add(makeButtonPanel(), BorderLayout.EAST);
        inputPanel.setBackground(Color.white);
        c.add(inputPanel);

        jd.setSize(250, 300);
        jd.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        jd.setVisible(true);

        return stockList;
    }

    public static Vector createStockListWindow(Vector tickers) {
        setStockTickerList(tickers);

        jd = new JDialog();
        Container c = jd.getContentPane();
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BorderLayout());
        inputPanel.add(makeTickerEntry(), BorderLayout.NORTH);
        inputPanel.add(makeStockListWindow(stockList), BorderLayout.CENTER);
        inputPanel.add(makeButtonPanel(), BorderLayout.EAST);
        inputPanel.setBackground(Color.white);
        c.add(inputPanel);

        jd.setTitle("Change Stocks");
        jd.setModal(true);
        jd.setSize(250, 300);
        //jd.setDefaultLookAndFeelDecorated( true );
        jd.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        jd.setVisible(true);

        return stockList;
    }

    private static void closeWindow() {
        jd.dispose();
        jd = null;
    }

    private static JScrollPane makeStockListWindow(Vector stocks) {
        stockRunList = new RunList(stocks) {
            public void run() {
                //takes the index of the highlighted stock so that another
                // method could remove it from the list
                selectedTickerElement = this.getSelectedIndex();
                jd.repaint();
            }
        };

        stockRunList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        return new JScrollPane(stockRunList);
    }

    private static JPanel makeTickerEntry() {
        JPanel tickerEntry = new JPanel();
        tickerEntry.add(new JLabel("Enter stock ticker:"));
        tickerInput = new RunTextField() {
            public void run()//dont want an action on every key press
            {
            }

            public void keyTyped(KeyEvent e)//action on press of enter
            {
                if (e.getKeyChar() == e.VK_ENTER) {
                    addTicker((tickerInput.getText().toUpperCase()));
                    stockRunList.setListData(stockList);

                    jd.repaint();
                }
            }
        };
        tickerInput.setColumns(8);

        tickerEntry.add(tickerInput);
        tickerEntry.setLayout(new FlowLayout());

        return tickerEntry;
    }

    private static JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();

        buttonPanel.add(new RunButton("Add") {
            public void run() {
                addTicker((tickerInput.getText().toUpperCase()));
                stockRunList.setListData(stockList);

                jd.repaint();
            }
        });
        buttonPanel.add(new RunButton("Delete") {
            public void run() {
                if (selectedTickerElement >= 0) {
                    removeStockTicker(selectedTickerElement);
                    jd.repaint();
                }
            }
        });
        buttonPanel.add(new RunButton("Clear") {
            public void run() {
                clearStockList();
                selectedTickerElement = -1;
                jd.repaint();
            }
        });
        buttonPanel.add(new RunButton("Done") {
            public void run() {
                closeWindow();
            }
        });
        buttonPanel.setLayout(new VerticalLayout(VerticalLayout.CENTER,
                5, 5, true, false));

        return buttonPanel;
    }

    private static void printAllTickers(Vector printme) {
        for (int i = 0; i < printme.size(); i++) {
            System.out.println((String) printme.elementAt(i));
        }
    }

    //main method to test this classes static dialog box methods
    public static void main(String args[]) {
        try {
            UIManager.setLookAndFeel(
                    UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println(e);
        }

        Vector v = createStockListWindow(initQuotes());
        printAllTickers(v);
    }

    //creates a vector for testing
    private static Vector initQuotes() {//this should open up the serialized preferences to load the previous instances stock list
        Vector s = new Vector();
        s.addElement("aapl");
        s.addElement("open");
        s.addElement("xlnx");
        s.addElement("altr");
        s.addElement("mot");
        s.addElement("cy");
        s.addElement("crus");
        s.addElement("sfa");
        s.addElement("adbe");
        s.addElement("msft");
        s.addElement("sunw");
        s.addElement("lxk");
        s.addElement("AMZn");
        s.addElement("NT");

        return s;
        //return Quote.getUrl( Quote.makeQuoteURLString( tickernames ) );
    }
}
