//============================================================================
// Edward Thompson
// 10/16/2005
//
// Homework Assignment 4
//          CR320
//
// Main
//      GUI for the display of stock quote information.  Will save the users
//  list of stock tickers upon exit, and load them up upon start.
//============================================================================
package net.stocks.stockViewer;

import gui.layouts.PreferredSizeGridLayout;
import gui.run.RunJob;
import gui.run.RunMenu;
import gui.run.RunMenuBar;
import gui.run.RunMenuItem;
import net.stocks.Quote;
import utils.PreferencesUtils;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;

public class Main extends gui.ClosableJFrame {
    private Vector quotes;//local vector for gui display
    private Vector tickernames;// = new Vector();//vector to hold just the ticker strings


    private JPanel labelPanel;
    private JLabel[] labels;

    private String prefs_key = "stock_quote_viewr_key";
    RunJob rj =  new RunJob(2, true) {
            public void run() {
              updateDisplay();
            }
        };

    public Main(String title) {
        super(title);
        tickernames = getTickerList();
    }

    //*************************************************************************
    //GUI initialization methods
    public void init() {
        setDisplayVector(getQuotes(tickernames));

        setContainerLayout(new BorderLayout());
        Container c = getContentPane();
        c.add(setJMenuBar(), BorderLayout.NORTH);
        setBackground(Color.white);
        setDisplayLabels();
        pack();
        setVisible(true);


    }

    private RunMenuBar setJMenuBar() {
        RunMenuBar mb = new RunMenuBar();
        mb.add(getFileMenu());
        mb.add(getEditMenu());
        return mb;
    }

    private RunMenu getFileMenu() {
        RunMenu fileMenu = new RunMenu("[File");
        fileMenu.add(new RunMenuItem("[quit{control q}") {
            public void run() {
                //this will save the current list of stocks, then exit
                saveTickerList();
                System.exit(0);
            }
        });
        return fileMenu;
    }

    private RunMenu getEditMenu() {
        RunMenu editMenu = new RunMenu("[Edit");
        editMenu.add(new RunMenuItem("[customize{control c}") {
            public void run() {
                //should open up a subwindow that allows the user to enter a list of stocks
                tickernames = Utils.createStockListWindow(tickernames, Main.this);
                setDisplayVector(getQuotes(tickernames));

                //need a method here to repaint the GUI properly, resize the menu, etc
                changeDisplayLabels();
            }
        });
        return editMenu;
    }

    //creates a new display panel displaying information for all
    // instance display vector elements
    private void setDisplayLabels() {
        labelPanel = new JPanel();

        labels = new JLabel[getDisplayVector().size()];
        for (int i = 0; i < getDisplayVector().size(); i++) {
            String s = (String) getDisplayVector().elementAt(i);
            labels[i] = new JLabel(s);
            labelPanel.add(labels[i]);
        }
        labelPanel.setLayout(new PreferredSizeGridLayout(0, 1, 5, 10));

        addComponent(labelPanel, BorderLayout.SOUTH);
    }
    //END GUI initialization methods
    //*************************************************************************

    //*************************************************************************
    //GUI update methods
    //
    // updates the display panel - removes everything in it previously,
    // and then creates a new display panel with the display vectors
    // for all instance display vector elements
    private void changeDisplayLabels() {
        labelPanel.removeAll();

        labels = new JLabel[getDisplayVector().size()];
        for (int i = 0; i < getDisplayVector().size(); i++) {
            String s = (String) getDisplayVector().elementAt(i);
            labels[i] = new JLabel(s);
            labelPanel.add(labels[i]);
        }
        labelPanel.setLayout(new PreferredSizeGridLayout(0, 1, 5, 10));

        addComponent(labelPanel, BorderLayout.SOUTH);
        pack();
    }

    //Updates the display by going to the web and getting the new quotes based on
    // the instance vector tickernames
    public void updateDisplay() {
        if (tickernames.size()==0) return;
        Vector quotes = getQuotes(tickernames);
        if (quotes.size()==0) return;
        setDisplayVector(quotes);
        for (int i = 0; i < getDisplayVector().size(); i++) {
            String text = (String) getDisplayVector().elementAt(i);
            if (text==null) return;
            labels[i].setText(text);
        }
    }

    public void paint(Graphics g) {
        if (!isVisible()) return;
        updateDisplay();
        rj.start();
        super.paint(g);
    }

    //END GUI update methods
    //*************************************************************************

    //saveTickerList will save the vector tickernames into the users preferences
    private void saveTickerList() {
        PreferencesUtils prefs = new PreferencesUtils(prefs_key);

        prefs.save(tickernames);
    }

    //getTickerList will retrieve the vector of ticker name strings from the
    // users preferences
    private Vector getTickerList() {
        Vector tickerList;

        PreferencesUtils prefs = new PreferencesUtils(prefs_key);

        tickerList = (Vector) prefs.restore();

        if (tickerList == null) {
            tickerList = new Vector();
        }

        return tickerList;
    }

    //setDisplayVector and getDisplayVector are synchronized methods because
    // the paint method utilizes a separate thread
    private synchronized void setDisplayVector(Vector v) {
        quotes = v;
    }

    private synchronized Vector getDisplayVector() {
        return quotes;
    }

    public static Vector getQuotes(Vector tickers) {
        return Quote.getUrl(Quote.makeQuoteURLString(tickers));
    }

    public static void main(String args[]) {


        Main qf = new Main("Stock Quote Viewer");
        qf.init();
    }
}