package net.server.servlets;

import javax.servlet.http.HttpServletRequest;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

/**
 * The SqlSynthesizer class encapsulates the functionality
 * required to construct sql statements which can then
 * be submitted to a database for processing.
 *
 * @author Robert Lysik
 * @version 1.00
 */
class SqlSynthesizer {
    private String[] sqlStatements;

    /**
     * This is the constructor for the SqlSynthesizer class.
     * An object of type HttpServletRequest is passed in as
     * a parameter. This object is parsed for information which
     * is used to construct the SQL statements.
     */
    SqlSynthesizer(HttpServletRequest request) {
        Vector sqlStatementVector = new Vector();

        String course = new String();
        String section = new String();
        String term = new String();
        String year = new String();
        String sqlStatement = new String();

        int rowCount = Integer.parseInt(request.getParameter("rows"));
        int colCount = Integer.parseInt(request.getParameter("cols"));

        course = request.getParameter("course");
        section = request.getParameter("section");
        term = request.getParameter("term");
        year = request.getParameter("year");

        String[] students = new String[rowCount + 1];
        String[][] value = new String[rowCount + 1][colCount];

        for (int index = 0; index < rowCount; index++)
            students[index] = request.getParameter("recordnum" + index);

        for (int rowIndex = 1; rowIndex <= rowCount; rowIndex++)
            for (int colIndex = 1; colIndex < colCount; colIndex++)
                value[rowIndex][colIndex] =
                        request.getParameter("r" + rowIndex + "c" + colIndex);

        for (int rowIndex = 1; rowIndex <= rowCount; rowIndex++)
            for (int colIndex = 1; colIndex < colCount; colIndex++) {
                sqlStatement = "insert into all_forms values (" +
                        students[rowIndex - 1] + ", '" +
                        course + "', '" +
                        section + "', '" +
                        term + "', '" +
                        year + "', " +
                        "1, '" +
                        "" + colIndex + "', " +
                        value[rowIndex][colIndex] + ");\r\n";


                sqlStatementVector.add(sqlStatement);
            }

        sqlStatements = new String[sqlStatementVector.size()];

        for (int index = 0; index < sqlStatementVector.size(); index++)
            sqlStatements[index] = (String) sqlStatementVector.get(index);
    }

    /**
     * This method constructs an insert statement based upon the
     * table name and values which are passed in as parameters.
     *
     */
    public String GetInsertStatement(String table, String[] values) {
        String statement = "insert into " + table + " values (";

        for (int index = 0; index < values.length - 1; index++)
            statement += values[index] + ", ";

        statement += values[values.length - 1] + ");";

        return statement;
    }

    /**
     * This method saves the SQL statements which have been
     * generated to a text file whose name is passed in as a parameter.
     *
     */
    public void save(String fileName) {
        FileWriter writer = null;

        try {
            writer = new FileWriter(fileName);
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }

        try {
            for (int index = 0; index < sqlStatements.length; index++)
                writer.write(sqlStatements[index]);

            writer.close();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /**
     * This method writes the SQL statements which have been generated
     * to the output console.
     */
    public void print() {
        for (int index = 0; index < sqlStatements.length; index++)
            System.out.println(sqlStatements[index]);
    }
}