package net.server.sendmail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;


public class SendMailApplet implements Runnable {

    String m_sRecipientEmail = null;	// The recipient email address
    String m_sSenderEmail = null;		// The sender email address
    String m_sServerHostName = null;	// The mail server
    String m_sMessage = null;			// The message text that gets mailed

    boolean m_bStandalone = false;
    int smtpPort = 25;					// Port 25 is the smtp mail port

    Socket socket;
    PrintStream ps;
    BufferedReader dis;
    InetAddress rina;
    InetAddress lina;


    Thread thread = new Thread(this);

    public void emailLyon(String msg) {
        email(msg,
                "192.168.1.95",
                "lyon@docjava.com",
                "lyon@docjava.com");
    }

    public void run() {
        sendNoException();
        System.out.println("email was sent!");
    }

    public void email(String msg,
                      String m_sServerHostName,
                      String m_sRecipientEmail,
                      String m_sSenderEmail) {
        setSenderEmail(m_sSenderEmail);
        setRecipientEmail(m_sRecipientEmail);
        setMailServerHostName(m_sServerHostName);
        setMessage(msg);


        thread.start();
    }


    public void sendNoException() {
        try {
            send();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**************************************************************
     * Send an e-mail message.
     **************************************************************/
    public void send() throws IOException {

        // Open connection to SMTP server
        socket = new Socket(m_sServerHostName, smtpPort);

        // Send the form contents as a message
        try {

            rina = socket.getInetAddress();
            lina = rina.getLocalHost();

            ps = new PrintStream(socket.getOutputStream());
            dis = new BufferedReader(
                    new InputStreamReader((socket.getInputStream())));

            // Send message
            sendline("HELO " + lina.toString());
            sendline("MAIL FROM:" + m_sSenderEmail);
            sendline("RCPT TO:" + m_sRecipientEmail);
            sendline("DATA");
            sendline(m_sMessage);
            sendline(".");


        } catch (Exception ex) {
            socket.close();
            //throw ex;
            System.out.println("Error; message send failed:\n " + ex.getMessage());
        }

        // Close connection
        socket.close();

    }//end method


    /**************************************************************
     * Send a line of data to the server, and retrieve the handshake
     **************************************************************/
    void sendline(String data) throws IOException {

        //System.out.println("sendline out:" + data);

        ps.println(data);
        ps.flush();

        String s = dis.readLine();
        System.out.println("sendline in:" + s);
    }//end method



    /**************************************************************
     * 	Mutator methods used to set the email properties
     *	prior to sending
     **************************************************************/

    /**************************************************************
     * Sets the message
     **************************************************************/
    public void setMessage(String msg) {
        this.m_sMessage = msg;
    }

    /**************************************************************
     * Sets the Sender's email address
     **************************************************************/
    public void setSenderEmail(String email) {
        this.m_sSenderEmail = email;
    }

    /**************************************************************
     * Sets the Recipient's email address
     **************************************************************/
    public void setRecipientEmail(String email) {
        this.m_sRecipientEmail = email;
    }

    public static void main(String args[]) {
        SendMailApplet sma = new SendMailApplet();
        sma.emailLyon("This is a test!!");
        System.out.println("Thread was started to send an email");
    }

    /**************************************************************
     * Sets the mail server host name
     **************************************************************/
    public void setMailServerHostName(String host) {
        this.m_sServerHostName = host;
    }

}//end class


