package net.scp;


import gui.In;
import utils.CompactJava;
import utils.PreferencesUtils;
import xml.Utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.io.*;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 13, 2004
 * <p/>
 * Time: 6:31:14 AM
 */
public class ScpBean implements ScpModelChangeEventListener,
                                 Serializable {

    private String user;
    private String host;

    private String localFile;
    private String remoteFile;
    private String password;
    private boolean isScp = true;

    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static String key = "net.ScpModel";


    public ScpBean() {

    }

    public void addModelChangeListener(ScpModelChangeEventListener smcl) {
        pcs.addPropertyChangeListener(smcl);
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void update() {
        if (isValidData())
         pcs.firePropertyChange("ScpModel", "changeIt", this);
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;

    }

    public String getLocalFile() {
        return localFile;
    }

    public void setLocalFile(String localFile) {
        this.localFile = localFile;

    }

    public String getRemoteFile() {
        return remoteFile;
    }

    public void setRemoteFile(String remoteFile) {
        this.remoteFile = remoteFile;
    }


    private boolean isNull(Object o) {
        return o == null;
    }

    public boolean isValidData() {
        final boolean rfNull = isNull(remoteFile);
        final boolean lfNull = isNull(localFile);
        final boolean uNull = isNull(user);
        final boolean pwNull = isNull(host);
        return !(rfNull |
                lfNull |
                uNull |
                pwNull);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static ScpBean fromXml(String xmlString) {
        return (ScpBean) Utils.decodeXml(xmlString);
    }

    public String toXml() {
        return CompactJava.toXml(this) + "</java>";
    }

    public String toString() {
        return toXml();
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        PreferencesUtils pu = new PreferencesUtils(key);
        pu.save(this);
    }
    /**
     * If uploads file, rerun the following main to
     * re-initialize settings for users.
     * This may occur if UID's or passwords are changed.
     * @param args
     */
    public static void main(String[] args) {
        ScpBean sm = new ScpBean();
        sm.setHost("show.docjava.com");
        sm.setUser("lyon");
        sm.setPassword(In.getPassword("enter password"));
        sm.setRemoteFile("/home/lyon/foo");
        sm.setLocalFile("/home/lyon/foo");
        sm.save();
        sm = ScpBean.restore();
        System.out.println(sm);
        System.out.println("uploading...");
        sm.upload();
        System.out.println("upload completed.");

    }

    /**
     * restores the properties from the preference in the user root.
     */
    public static ScpBean restore() {
        PreferencesUtils pu = new PreferencesUtils(key);
        Object o = pu.restore();
        if (o instanceof ScpBean) return (ScpBean)o;
        return new ScpBean();
    }

    public void propertyChange(PropertyChangeEvent evt) {

    }

    public void scpModelChanged(ScpModelChangeEvent modelChangedEvent) {
        ScpBean m = modelChangedEvent.getScpModel();
        setHost(m.getHost());
        setLocalFile(m.getLocalFile());
        setRemoteFile(m.getRemoteFile());
        setUser(m.getUser());
        setPassword(m.getPassword());
        pcs.firePropertyChange(modelChangedEvent);
    }

    public SimpleUserInfo getSimpleUserInfo() {
        return new SimpleUserInfo(getUser(),getPassword());
    }

    public String getPassword() {
        return password;
    }

    public void upload() {
        final SimpleUserInfo simpleUserInfo = getSimpleUserInfo();
        if (password==null){
            password = In.getPassword("enter remote host password");
            save();
            simpleUserInfo.setPassword(password);
        }
        System.out.println(simpleUserInfo);
        if (isScp())
            ScpTo.scpTo(getLocalFile(),
                    getHost(),
                    getRemoteFile(),
                    simpleUserInfo);
        if (!isScp())
            ScpTo.sftpTo(getLocalFile(),
                    getHost(),
                    getRemoteFile(),
                    simpleUserInfo);

    }



    public boolean isScp() {
        return isScp;
    }

    public void setScp(boolean scp) {
        isScp = scp;
    }


}
