package net.rmi.utils;

import gui.In;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Oct 13, 2004
 * Time: 1:27:44 PM
 * net.rmi.utils.RmiRegistryUtils
 * Is a singleton pattern that lets you get the local registry.
 */
public final class RmiRegistryUtils {
    // use singleton pattern and
    // prevent instantiation of RmiRegistryUtils.

    private RmiRegistryUtils(){}
    // the only instance of the Registry held by the RmiRegistryUtils
    private static Registry registry;

    public static void listNames(){
        System.out.println("registry:" + registry + " names:");
        try {
            print(registry.list());
        } catch (RemoteException e) {
            In.message(e);

        }
    }
    public static void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    /**
     * Checks whether a Registry has been started on this host.
     * If not, it tries to start one.
     * when it fails to start a Registry, it exits the program
     * with exit code 1.
     */
    public static void restart() {
        if (isRegistryRunning())
            return;
        try {
            startRegistry();
        } catch (RemoteException e) {
            In.message(e);

        }
    }

    private static boolean isRegistryRunning() {
        try {
            if (registry == null) return false;
            java.rmi.Naming.list("/");
            return true;
        } catch (RemoteException e) {
            return false;
        } catch (MalformedURLException e) {
            return false;
        }
    }
    /**
     * Restart the registry, if needed.
     * Return the only instance of the registry for consistent global
     * using by making use of the Singleton Design Pattern
     * @return the internally held registry instance.
     */
    public static Registry getRegistry() {
        restart();
        return registry;
    }
    private static void startRegistry() throws RemoteException {
        try {
            registry = new sun.rmi.registry.RegistryImpl
                    (Registry.REGISTRY_PORT);
        } catch (Exception e) {
            registry =LocateRegistry.getRegistry();
        }
    }

    public static void main(String args[]) {
        restart();
        listNames();
        In.message("Registry Started");
    }
}
