package net.rmi.utils;

import classUtils.putils.ClassPathUtils;
import classUtils.reflection.ReflectUtil;
import gui.In;
import utils.SystemUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.Remote;

public class Compile {

    public static void main(String args[]) {
        rmicTestDos2();
        //startWebStart();
        //WebStartUtils.testGetWebstartLocation();
    }

    public static void rmic() {
        String
                fn = "rmi.rmiimage.Server";
        rmic(fn);
    }

    public static void rmicTestDos() {
        Runtime rt = Runtime.getRuntime();
        String args[] = {
            "dir"
        };
        try {
            Process p = rt.exec(args,
                    null,
                    new File("c:\\lyon\\j4p\\classes"));
            BufferedReader br
                    = new BufferedReader(
                            new InputStreamReader(p.getErrorStream()));
            String s;
            while ((s = br.readLine()) != null)
                System.out.println("dos:" + s);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    // For homework, automate the computation of
    // the following variables:
    /*
        File workingDirectory = new File("c:\\lyon\\j4p\\classes");
        String className = "net.rmi.armi.RemoteHelloImplementation";
        String destinationDirectory = "c:\\lyon\\j4p\\classes\\net\\rmi\\armi\\";
        String classPath = "c:\\lyon\\j4p\\classes\\";
    */
    private static void rmicTestDos2() {
        Class c = net.rmi.rjs.RmiFileServerImplementation.class;
        runRmic(c);

    }
    public static boolean isImplementingRemoteInterface(Class c) {
       Class ca[]= ReflectUtil.getAllInterfaces(c);

       Class remoteClass = Remote.class;
        for (int i=0; i < ca.length; i++){
            System.out.println(ca[i]);
            if (ca[i].equals(remoteClass)) return true;
        }
        return false;
    }
    /**
     * Run rmic
     * @param c target of the rmic command
     */
    public static void runRmic(Class c) {
        System.out.println("running rmic on:"+c.getName());
        if (!isImplementingRemoteInterface(c) ){
            In.message("Class:"+c.getName()+
                    " does not implement the Remote Interface\nProgram dies");
            System.exit(0);
        }
        File workingDirectory =
                new File(ClassPathUtils.getClassPathInUserDir());
        System.out.println(workingDirectory.toString());
        checkFile(workingDirectory);

        File destinationDirectory = new File(workingDirectory.toString());
        System.out.println("output to>"+destinationDirectory.getAbsolutePath());
        String classPath = workingDirectory.toString();
        runRmic(classPath,
                destinationDirectory,
                workingDirectory,
                c);
    }

    public static void rmicTester() {
        File workingDirectory =
                new File(ClassPathUtils.getClassPathInUserDir());
        String classPath = workingDirectory.toString();
        String version = "-v1.2";
        File destinationDirectory = new File(workingDirectory.toString());

        Class clazz = net.rmi.rjs.RmiFileServerImplementation.class;
        rmic(version, classPath, destinationDirectory, clazz);
    }
    public static void checkFile(File f) {
        if (!f.exists()) {
            In.message("could not find: " +
                    f +
                    "\n Program exits!");
            System.exit(0);
        }
    }

    /**
     * This invocation fails on a mac.
     *
     * @param classPath            location of classes with multiple
     *                             directories and jars.
     * @param destinationDirectory place to put the stubs
     * @param workingDirectory     place from which to launch the program.
     * @param c            target of the stub generator.
     */
    public static void runRmic(String classPath,
                               File destinationDirectory,
                               File workingDirectory,
                               Class c) {
        String rmicLocation = SystemUtils.getRmicPath().toString();
        System.out.println("rmicLocation="+rmicLocation);
        String args[] = {
            rmicLocation,
            "-v1.2",
            "-classpath", classPath,
            "-d", destinationDirectory.toString(),
            c.getName()
        };
        try {
            runExec(args, workingDirectory);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * my Theory is that you can kill the process at any time and not
     * bother reading the output with a readline...however this has not
     * been tested.
     *
     * @param args
     * @param workingDirectory
     * @return the process that is running in its own thread
     */
    public static Process asynchronousRunExec(final String[] args,
                                               final File workingDirectory) {
        final Process[] p = new Process[]{null};
        Thread t = new Thread(new Runnable() {
            public void run() {
                Runtime rt = Runtime.getRuntime();
                try {
                    p[0] = rt.exec(args, null, workingDirectory);
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
        return p[0];
    }

    /**
     * Asynchronous invocation of the OS commands in the args directory
     *
     * @param args
     * @param workingDirectory
     * @return A stoppable process.
     * @throws IOException
     */
    public static Runtime asyncRunExec(final String[] args,
                                       final File workingDirectory)
            throws IOException {
        final Runtime rt = Runtime.getRuntime();
        final Process p;
        p = rt.exec(args, null, workingDirectory);
        Thread t = new Thread(new Runnable() {
            public void run() {
                try {

                    BufferedReader br
                            = new BufferedReader(new InputStreamReader(
                                    p.getErrorStream()));
                    String s;
                    while ((s = br.readLine()) != null)
                        System.out.println("dos:" + s);
                } catch (IOException e) {
                    e.printStackTrace();

                }

            }
        });
        t.start();
        return rt;
    }

    /**
     * Run the args array using the workingDirectory as the home.
     *
     * @param args
     * @param workingDirectory
     * @throws IOException
     */
    public static void runExec(String[] args,
                               File workingDirectory) throws IOException {
        //for (int i = 0; i < args.length; i++)
        //    System.out.print(" " + args[i]);
       // System.out.println("\nworking directory=" + workingDirectory);

        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(args, null, workingDirectory);
        // this could be the error stream or the input stream.
        // probably we should output these two things
        // to files, but I need a cross-platform way to do that.
        BufferedReader br
                = new BufferedReader(
                        new InputStreamReader(p.getInputStream()));
        String s;
        while ((s = br.readLine()) != null)
            System.out.println("os:" + s);
        try {
            p.waitFor();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }



    public static void rmic(String version,
                            String classpath,
                            File destinationDirectory,
                            Class clazz) {
        String args[] = {
            version,
            "-classpath", classpath,
            "-d", destinationDirectory.toString(),
            clazz.getName()
        };
        rmic(args);
    }

    public static void rmic(String[] args) {
        sun.rmi.rmic.Main.main(args);
    }

    public static void rmicHelp(){
        String args[] ={
            "-help"
        };
        rmic(args);
    }
    /**
     * This is an older version of RMI that no longer
     * works with jdk version 1.4 or higher!
     * @param c
     */
    public static void rmic(Class c) {
        String cn = c.getName();
        String cp = ClassPathUtils.getClassPathInUserDir();
        String args[] = {
            "-classpath", cp,
            "-v1.2",
            "-d", cp,
            cn
        };
        sun.rmi.rmic.Main.main(args);
    }

    static public void rmic(String fn) {
        String args[] = {fn};
        rmic(args);
    }
}