package net.rmi.rmiimage;

import java.rmi.Naming;

class StartBenchmark extends Thread {
  int servernumber;

  static BenchMark BM[] = new BenchMark[26];
  CpuPanel cpu[] = new CpuPanel[26];

  public static boolean checkServers(int i, String servername) {
    try {
      System.out.println("Looking up servers...");
      System.out.println("Checking server " + servername);
      BM[i] = (BenchMark) Naming.lookup(servername);
      System.out.println("Server checked!");
      return true;
    } catch (Exception e) {
      System.out.println("The exception in checking server: " + e);
    }
    return false;
  }

  public StartBenchmark(int i, CpuPanel Cpu) {
    servernumber = i;
    cpu[i] = Cpu;
  }

  public void run() {
    long starttime, endtime;
    try {
      starttime = System.currentTimeMillis();
      BM[servernumber].multiplyBench(999999);
      endtime = System.currentTimeMillis();
      System.out.println("The time taken is: " +
                         (endtime - starttime));
      cpu[servernumber].setSpeed((endtime - starttime));
    } catch (Exception e) {
      System.out.println(e);
    }
  }
}

public class Client {
  static String serverNames[] = {
    "rmi://" + "localhost" + ":1099/HelloServer",

  };
    public static void main(String[] args) {
        int stateArray[] = new int[1];
        Client c = new Client(stateArray);
        c.Start(0,null);

    }

  StartBenchmark sb[] = new StartBenchmark[serverNames.length];
  boolean b[] = new boolean[serverNames.length];

  public Client(int statearr[]) {
    for (int i = 0; i < serverNames.length; i++) {
      if (statearr[i] == 1)
        b[i] = StartBenchmark.checkServers(i,
                                           serverNames[i]);
    }
  }

  public void Start(int i, CpuPanel Cpu) {
    if (b[i]) //&& !(sb[i].isAlive()))
    {
      sb[i] = new StartBenchmark(i, Cpu);
      sb[i].start();
    } else
      System.out.println("Server " + serverNames[i] + " not found");
  }
}
