package net.rmi.rjs.pk.rmissl;


import net.rmi.utils.RmiRegistryUtils;
import java.rmi.Naming;
import java.rmi.registry.Registry;
import java.awt.*;
import gui.JInfoFrame;
import gui.run.RunButton;


/**
 * Created by IntelliJ IDEA.
 * User: pkrepszt
 * Date: Nov 14, 2004
 * Time: 7:19:49 PM
 * To change this template use File | Settings | File Templates.
 */
public class WebServerRmiSsl{
    /**
     *  SSL socket port
     */
    public final int port = 9000;
     /**
     *  RMI SSL implemntation
     */
    public RmiSSLImplementation rsl;
    private JInfoFrame jif = new JInfoFrame("Web Server");
    /**
     *   WebServerRmiSsl constructor starts the RMI/SSL server
     */
    public WebServerRmiSsl() {
        Container c = jif.getContentPane();
        c = jif.getContentPane();
        c.add(
                new RunButton("Exit") {
                    public void run() {
                        System.exit(0);
                    }
                }, BorderLayout.SOUTH);
        jif.setSize(500, 200);
        jif.setVisible(true);
        jif.println("Starting Web Server");
        startServer();
    }

    public static void main(String args[]) {
        new WebServerRmiSsl();
    }
    /**
     * starts the RMI/SSL Server
     * bound in RMI registry
     */
    private void startServer() {
        try {
            Registry r = RmiRegistryUtils.getRegistry();
            System.out.println("r "+r.toString());
            rsl = new RmiSSLImplementation(port);
            String address = "rmi://localhost/"+ rsl.REMOTE_NAME;
            System.out.println( " address " + address);
            Naming.rebind(address, rsl);
            jif.println("rmissl.WebServerRmiSsl bound in registry");
            System.out.println("rmissl.WebServerRmiSsl bound in registry");
        } catch (Exception e) {
            System.out.println("rmissl.WebServerRmiSsl err bounding in registry: " + e.getMessage());
            jif.println("rmissl.WebServerRmiSsl err bounding in registry: " + e.getMessage());
            e.printStackTrace();
        }
    }

}