/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.pk.LusCs;

import gui.ClosableJFrame;
import gui.layouts.DialogLayout;

import javax.swing.*;
import java.awt.*;
import java.util.Observable;
import java.util.Observer;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 1, 2005
 * <p/>
 * Time: 5:54:44 PM
 */
public class CsRecordPanel extends JPanel implements Observer {
    private CsRecord csr ;
    private JLabel speedLabel ;
    private JLabel busyLabel;
    private JLabel ageLabel ;
    public CsRecordPanel(CsRecord csr){
        this.csr = csr;
        speedLabel = new JLabel("      ");
        busyLabel = new JLabel(csr.isBusy() + "");
        final long age = csr.getAge();

        ageLabel = new JLabel(age/1000 + "");
        csr.addObserver(this);
        setLayout(new DialogLayout());
        add(new JLabel("speed in mflops:"));
        add(speedLabel);
        final String ipAddrString =
                csr.getIpAddress().getHostAddress();
        add(new JLabel("busy:"));
        add(busyLabel);
        add(new JLabel("age (sec)"));
        add(ageLabel);
        setBorder(BorderFactory.createTitledBorder(ipAddrString));
        update();
    }
    public void update(){
        speedLabel.setText(csr.getBmb().getMflops() + "");
        busyLabel.setText(csr.isBusy()+"");
        ageLabel.setText(csr.getAge()+"");
    }
    public void update(Observable obs, Object obj){
        update();
    }
    public static void main(String[] args) {
        ClosableJFrame cf = new ClosableJFrame();
        JPanel jp = new JPanel();
        Container c = cf.getContentPane();
        jp.setLayout(new GridLayout(4,0));
        for (int i=0; i < 16; i++){
            jp.add(new CsRecordPanel(new CsRecord()));
        }
        JScrollPane jsp = new JScrollPane(jp);
        c.add(jsp);
        cf.pack();
        cf.setVisible(true);
    }
}
