/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.pk.LusCs;

import gui.run.RunJob;
import utils.OsUtils;
import utils.SystemUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Aug 8, 2005
 * <p/>
 * Time: 9:24:55 AM
 */
public  class CheckForDeathJobProperties extends RunJob {
    private final static String key = "csKillKey";
    private Properties p = new Properties();

    public final static File propFile = new File(SystemUtils.getTmpDir() +
            SystemUtils.getDirectorySeparator() +
            "out.properties");
    public CheckForDeathJobProperties() {
        super(5);
        if (OsUtils.isMacOs())
            startRunCheckThread();
    }
    public static void main(String[] args) {
        new CheckForDeathJobProperties();
    }
    public void killMe(){
        p.setProperty(key,"true");
    }
    public void startRunCheckThread() {


        p.setProperty(key, "false");
        try {
            FileOutputStream fos = new FileOutputStream(propFile);
            p.store(fos, "RJS CS property");
            fos.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    public void run(){
        checkForDeathFlag();
    }

    private void checkForDeathFlag() {
        try {
            if (propFile == null) return;
            if (!propFile.exists()) return;
            FileInputStream fis = new FileInputStream(propFile);
            if (fis == null) return;
            if (p == null) return;
            p.load(fis);
            fis.close();
           // System.out.println("prop:" + p.getProperty(key));
        } catch (IOException e) {
            e.printStackTrace();
        }
        String value = p.getProperty(key);
        //System.out.println(value);
        if (value == null) return;
        if (value.equals("false")) return;
        killCS();//kill the CS
    }



    private void killCS() {
        System.out.println("cs is dead");
        System.exit(0);
    }
}
