/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.fc;

import j2d.ImageUtils;
import java.io.File;
import java.util.Calendar;
import java.awt.*;

/**
 * @author Francisco Castellanos
 *
 */

public class FractalsMonitorThread extends Thread{

	Image[] images;
	Calendar cal;
	File f;
	int imgQty;
	String outputDir;
	TestFractalJobs tfj;
	boolean status;
	
	public FractalsMonitorThread(Image[] imgs, String outD, TestFractalJobs t){
		images = imgs;
		outputDir = outD;
		f = new File(outD);
		imgQty = imgs.length;
		tfj = t;
		status = false;
	}
	
	public void run(){
		try{
			FractalsFileNameFilter fnf = new FractalsFileNameFilter();
			String[] fileNames = f.list(fnf);
			System.out.println("number of files = " + fileNames.length);
			
			int count = 0;
			if (fileNames.length == imgQty){
				getNewImages(fileNames);
			}else{
				status = true;
				do{
					cal = Calendar.getInstance();
					System.out.println("Monitoring output location " + cal.getTime().toString());
					sleep(2000);
					fileNames = f.list(fnf);
					if (count < fileNames.length){
						getNewImages(fileNames);
					}
					count = fileNames.length;
				}while (fileNames.length < imgQty );
				System.out.println("Monitoring terminated");
				status = false;
			}
		}catch(Exception e){
			System.err.println("Exception @ Monitor thread");
			e.printStackTrace();
		}
	}

	public void getNewImages(String[] fileNames){
		for (int i=0; i < fileNames.length; i++){
			int indxNo = fileNames[i].indexOf(".ppm.jar") - 1;
			int imgNo = (new Integer(
								new Character(fileNames[i].charAt(indxNo)).toString())).intValue() - 1;
			//System.out.println("char = " + imgNo);
			if (images[imgNo] == null){
				try{
					File outFile = new File(outputDir, fileNames[i]);
					images[imgNo] = ImageUtils.getPpmJar(outFile);
				}catch(Exception e){
					System.err.println("Exception @ getNewImages");
					e.printStackTrace();
				}
				tfj.repaintImagePanel(imgNo);
			}
		}	
	}
	
	public boolean getStatus(){
		return status;
	}
}
	
