/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.fc;

import javax.swing.*;
import java.awt.*;

public class FractalsImagePanel extends JPanel {

    private int noParts;

    private Image[] images;

    FractalImgPanel[] fjp;

    public FractalsImagePanel(Image[] imgs) {
        //setLayout(new FlowLayout(FlowLayout.LEFT));
    	images = imgs;
    	noParts = imgs.length;
        setLayout(new GridLayout(8, 1, 3, 3));

        fjp = new FractalImgPanel[noParts];

        for (int i=0; i < noParts; i++){
        	fjp[i] = new FractalImgPanel(images, i);
            add(fjp[i]);
        }
    }

    public Image[] getImages() {
        return images;
    }

    public void repaintPanel(int indx){
    	if (fjp[indx] == null)System.out.println("fjp[" + indx + "]=null");
    	fjp[indx].repaint();
    }

}
