package net.rmi.rjs;

import futils.Futil;
import gui.In;

import java.io.File;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class RmiFileClientTest {
    private String rmiUrl = null;
    private RMIFileServerInterface rmiFileServerInterface = null;
    private static String REMOTE_NAME = RmiFileServerImplementation.REMOTE_NAME;
    // as long as you have a static ref, SDA will load the stubs.

    public RmiFileClientTest(String location) {
        rmiUrl = location;
        try {
            rmiFileServerInterface = lookupServer();
        } catch (NotBoundException e) {
            e.printStackTrace();
        } catch (java.net.MalformedURLException e) {
            e.printStackTrace();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public RMIFileServerInterface getRmiFileServerInterface() {
        return rmiFileServerInterface;
    }

    private RMIFileServerInterface lookupServer()
            throws NotBoundException,
                   java.net.MalformedURLException,
                   RemoteException {
        return (RMIFileServerInterface)
                Naming.lookup(rmiUrl);
    }

    public static void main(String args[]) {
        try {
            final String serverHostName = In.getString("enter remote host");

            File fileToUpload = Futil.getReadFile("select a readfile to upload");
            final String remoteFileName = "test.txt";

            uploadFile(fileToUpload, remoteFileName, serverHostName);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void uploadFile(File fileToUpload,
                                   final String remoteFileName,
                                   final String serverHostName)
            throws RemoteException {

        String location = "rmi://" +
                        serverHostName +
                        "/" +
                        REMOTE_NAME;
        RmiFileClientTest rhc =
                new RmiFileClientTest(location);
        RMIFileServerInterface rfs = rhc.getRmiFileServerInterface();
        rfs.testGetMsg();

        byte b[] = Futil.readBytes(fileToUpload);
        System.out.println("got b.length=" + b.length);

        rfs.putFile(remoteFileName, b);
        byte b2[] = rfs.getFile(remoteFileName);
        System.out.println(
                "got the file back with b.length=" + b2.length);
    }

    public String getMsg() throws RemoteException {
        return rmiFileServerInterface.getMsg();
    }

    public void testGetMsg()
            throws
            RemoteException {
        System.out.println(rmiFileServerInterface.getMsg());
    }
}
