package net.rmi.dfs;

import futils.Futil;
import gui.In;

import java.io.File;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

import net.rmi.rjs.RMIFileServerInterface;
import net.rmi.rjs.RmiFileServerImplementation;

public class DFSTest {
    private String rmiUrl = null;
    private DFSInterface dfsInterface = null;
    private static String REMOTE_NAME = DFSImplementation.REMOTE_NAME;
    // as long as you have a static ref, SDA will load the stubs.

    public DFSTest(String location) {
        rmiUrl = location;
        try {
            dfsInterface = lookupServer();
        } catch (NotBoundException e) {
            e.printStackTrace();
        } catch (java.net.MalformedURLException e) {
            e.printStackTrace();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public DFSInterface getDfsInterface() {
        return dfsInterface;
    }

    private DFSInterface lookupServer()
            throws NotBoundException,
                   java.net.MalformedURLException,
                   RemoteException {
        return (DFSInterface)
                Naming.lookup(rmiUrl);
    }

    public static void main(String args[]) {
        try {
            final String serverHostName = In.getString("enter remote host");

            File fileToUpload = Futil.getReadFile("select a readfile to upload");
            final String remoteFileName = "test.txt";

            uploadFile(fileToUpload, remoteFileName, serverHostName);


        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void uploadFile(File fileToUpload,
                                   final String remoteFileName,
                                   final String serverHostName)
            throws RemoteException {

        String location = "rmi://" +
                        serverHostName +
                        "/" +
                        REMOTE_NAME;
        DFSTest rhc =
                new DFSTest(location);
        DFSInterface rfs = rhc.getDfsInterface();

        rfs.mkdir("foo");
        rfs.cd("foo");
        byte b[] = Futil.readBytes(fileToUpload);
        System.out.println("got b.length=" + b.length);

        rfs.putFile(remoteFileName, b);
        byte b2[] = rfs.getFile(remoteFileName);
        System.out.println(
                "got the file back with b.length=" + b2.length);
        print(rfs.ls());
    }

    private static void print(String[] s) {
        for (int i=0; i <s.length;i++ )
            System.out.println(s[i]);
    }
}
