package net.rmi.dfs;

import net.rmi.utils.RmiRegistryUtils;
import net.rmi.rjs.RmiFileServerImplementation;
import net.rmi.rjs.RMIFileServerInterface;

import java.rmi.RemoteException;
import java.rmi.registry.Registry;

public class DFSMain {

    public static void main(String args[]) {
        
        try {
            startServer();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static void startServer()
            throws RemoteException {
        println("starting server");
        //Class c = RMIFileServerImplementation.class;
        //Compile.runRmic(c);
        DFSInterface ro = new DFSImplementation();

        bindInstances(ro);
    }

    private static void bindInstances(DFSInterface ro)
            throws RemoteException {
        println("binding remote instances");
        Registry r = RmiRegistryUtils.getRegistry();

        r.rebind(DFSImplementation.REMOTE_NAME, ro);
        println("waiting for invocations");
    }


    public static void println(Object o) {
        System.out.println(o);
    }
}
