package net.rmi.dfs;

// net.rmi.armi.RemoteHelloImplementation;

import futils.Futil;
import utils.SystemUtils;

import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

// todo implement the put and get features of the RMIFileServerImplementation and
// test them with remote method invocation.
// due next week.

public class DFSImplementation
        extends UnicastRemoteObject
        implements DFSInterface {

    public static String REMOTE_NAME = "DFSMain";
    private File f = new File(SystemUtils.getUserHome());

    public DFSImplementation()
            throws RemoteException {
    }

    public byte[] getFile(String fileName) throws RemoteException {
        File f2 = new File(f +
                SystemUtils.getDirectorySeparator() +
                fileName);
        return Futil.readBytes(f2);
    }

    public void putFile(String fileName, byte data[]) throws RemoteException {
        if (data == null) System.out.println("Data=null!");
        File f2 = new File(f +
                SystemUtils.getDirectorySeparator() +
                fileName);
        Futil.writeBytes(f2, data);
        System.out.println("wrote file:" + f2.getAbsolutePath());
    }

    public String [] ls() throws RemoteException {
        return f.list();
    }

    public void mkdir(String dir) throws RemoteException {
        File fdir = new File(f + SystemUtils.getDirectorySeparator() + dir);
        if (fdir.isDirectory()) {
            System.out.println("ER!" + fdir.getAbsolutePath() + " already exists!");
            return;
        }
        fdir.mkdir();
    }

    public void cd(String dir) throws RemoteException {
        if (dir.equals("..")) {
            File temp = f.getParentFile();
            if (temp == null) return;
            f = temp;
            return;
        }
        File temp = new File(
                f.getAbsolutePath() + SystemUtils.getDirectorySeparator() + dir);
        if (!temp.exists()) {
            System.out.println("ER!" + temp.getAbsolutePath() + " does not exist!");
            return;
        }

        if (!temp.isDirectory()) {
            System.out.println("ER!" + temp.getAbsolutePath() + " is not a dir");
            return;
        }
        f = temp;
        System.out.println(temp);
    }


}

// use the rmic compiler to create a stub
// rmic -v1.2 -d . net.rmi.armi.RemoteHelloImplementation
