package net.rmi;

import net.rmi.utils.RmiRegistryUtils;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.net.InetAddress;
import java.net.UnknownHostException;

import gui.In;

public class ComputeServer
    extends UnicastRemoteObject
    implements Computable {

  // rmi servers must have
  // a public constructor that throws a
  // RemoteException
  public ComputeServer() throws RemoteException {
  }

  //in rmi, parameters must be serializale
  public void println(Serializable o)
      throws RemoteException {
    System.out.println(o);
  }

  //servers must gui.run RMIC
  public static void main(String[] args)
          throws RemoteException, UnknownHostException {
      testGetLocalHost();
    //System.setSecurityManager(
    //    new RMISecurityManager());

      lookUpServerAndBindWithRegistry();

  }
  public static void testGetLocalHost(){
      try {
          System.out.println(getLocalHost().getHostAddress());
      } catch (UnknownHostException e) {
          e.printStackTrace();

      }
  }
  public static InetAddress getLocalHost() throws UnknownHostException {
      InetAddress ia = InetAddress.getLocalHost();

      return ia;
  }
  private static void lookUpServerAndBindWithRegistry()
          throws java.rmi.RemoteException, UnknownHostException {

    ComputeServer cs =
        new ComputeServer();
      String ipAddress = getLocalHost().getHostAddress();
      In.message("serving ip address:"+ipAddress);
      String url =
          "rmi://" +
                  ipAddress +
                  "/ComputeServer";
      Registry r = RmiRegistryUtils.getRegistry();
      r.rebind(url,cs);
    //java.rmi.Naming.rebind(url, cs);
    System.out.println("server started");
  }
}
