/*
 * @author Douglas A. Lyon
 * @version  Nov 17, 2002.1:37:08 PM
 */
package net.proxy;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.UnknownHostException;
import java.util.Properties;

public class Proxy {
    public static void main(String[] args) {
        printProxy();
    }

    public static void printProxy() {
        setSoeProxy();
        String s = System.getProperty(
                "network.proxy.type");
        System.out.println(s);
    }

    /**
     * use a proxy server when connecting to the
     * web. SOE = School of Engineering at
     * Fairfield. For example: Proxy.setSoeProxy();
     */
    public static void setSoeProxy() {
        setHttpProxy("172.16.10.3", "8080");
    }


    public static void setHttpProxy(String host,
                                    String port) {
        Properties p = System.getProperties();
        p.put("proxySet", "true");
        p.put("proxyHost", host);
        p.put("proxyPort", port);
    }

    public static void setFtpProxy(String host,
                                   String port) {
        Properties p = System.getProperties();
        p.put("ftpProxySet", "true");
        p.put("ftpProxyHost", host);
        p.put("ftpProxyPort", port);
    }

    public static PasswordAuthentication
            getHttpPasswordAuthentictor() {
        String scheme = "basic";
        String prompt = "Enter UID and passwd";
        String protocol = "http/1.1";
        int port = 80;
        InetAddress inetAddr =
                getLocalHost();
        return Authenticator.requestPasswordAuthentication(
                inetAddr,
                80,
                protocol,
                prompt,
                scheme);
    }

    private static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        } catch (UnknownHostException e) {
            System.out.println(
                    "unable to get localhost IP address!");
            return null;
        }
    }
}
