package net.multicast.multiMedia;

import java.io.*;
import java.util.prefs.Preferences;

/**
 * Created by IntelliJ IDEA.
 * User: ehogan
 * Date: Dec 14, 2004
 * Time: 5:49:02 PM
 * To change this template use File | Settings | File Templates.
 */
public class MultiCastBean implements Serializable {
    private boolean isAudioRcv = false;
    private boolean isAudioXmt = false;
    private boolean isVideoRcv = false;
    private boolean isVideoXmt = false;
    private boolean isChatRcv = false;
    private boolean isChatXmt = false;
    private static String key = "MultiCastPrefBeanProps";

    public static void main(String[] args) {
        MultiCastBean pb = MultiCastBean.restore();
        System.out.println(pb);
        pb.save();
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * restores the properties from the preference in
     * the user root.
     */
    public static MultiCastBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new MultiCastBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (MultiCastBean) o;
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return new MultiCastBean();
    }


    public boolean isAudioRcv() {
        return isAudioRcv;
    }

    public void setAudioRcv(boolean audioRcv) {
        isAudioRcv = audioRcv;
    }

    public boolean isAudioXmt() {
        return isAudioXmt;
    }

    public void setAudioXmt(boolean audioXmt) {
        isAudioXmt = audioXmt;
    }

    public boolean isVideoRcv() {
        return isVideoRcv;
    }

    public void setVideoRcv(boolean videoRcv) {
        isVideoRcv = videoRcv;
    }

    public boolean isVideoXmt() {
        return isVideoXmt;
    }

    public void setVideoXmt(boolean videoXmt) {
        isVideoXmt = videoXmt;
    }

    public boolean isChatRcv() {
        return isChatRcv;
    }

    public void setChatRcv(boolean chatRcv) {
        isChatRcv = chatRcv;
    }

    public boolean isChatXmt() {
        return isChatXmt;
    }

    public void setChatXmt(boolean chatXmt) {
        isChatXmt = chatXmt;
    }

    private boolean isBothChecked(boolean b, boolean b1) {
        if (b && b1)
            return true;
        return false;
    }

    public boolean isValidData() {
        final boolean isVideoBothChecked = isBothChecked(isVideoRcv, isVideoXmt);
        if (isVideoBothChecked)
            return false;
        return true;
    }
}
