package net.mail.swing;



import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;


public class CheckMail extends JApplet{

  private Socket socket;
  private String serverHostName = null;
  private PrintWriter ps;
  private InetAddress rina, lina;
  private int popPort = 110;
  private boolean standalone = false;

  private CheckMailPanel form;


  /**
   * Initialize the applet.
   */
  public void init() {
    form = new CheckMailPanel(this);
    getContentPane().add(form);
    form.setSize(300, 300);
    setBackground(Color.blue);
    if (serverHostName == null) serverHostName = getCodeBase().getHost();
    System.out.println("ServerHostName=" + serverHostName);
  }


  /**
   * Show status text to the user.
   */
  public void showStatus(String s) {

    System.out.println(s);
    if (standalone) return;
    super.showStatus(s);
  }

  private BufferedReader buf_reader;

  /**
   * Perform check for e-mail.
   */
  public void checkForMail() throws IOException, NumberFormatException, Exception {

    showStatus("Checking for mail on " + serverHostName);

    socket = new Socket(serverHostName, popPort);    //  open a connection

    String rs;

    

    try {
      rina = socket.getInetAddress();
      lina = InetAddress.getLocalHost();

      //
      //  Conversion of the PrintStream due to deprication.
      //     ps = new PrintStream(socket.getOutputStream());
      //
      //  Print values and objects to a Writer.
      //
      ps = new PrintWriter(
          socket.getOutputStream());

      //
      //  Conversion of the DataInputStream due to deprecation.
      //    dis  = new DataInputStream(socket.getInputStream());
      //
      //  Use BufferedReader instead of DataInputStream.
      //
      buf_reader = new BufferedReader(
          new InputStreamReader(socket.getInputStream()));

      //
      //  Check for messages
      //
      sendline("USER " + form.getId());
      rs = sendline("PASS " + form.getPswd());
      //if (rs.charAt(0) != '+') throw new Exception("Incorrect password");
      rs = sendline("STAT");
    } catch (Exception ex) {
      socket.close();
      throw ex;
    }

    // Close connection
    socket.close();

    // Parse result
    int r = 0;
    r = Integer.parseInt(rs.substring(17, rs.indexOf(" messages")));

    // Update result field
    form.getResultField().setText(Integer.toString(r));
  }

  /**
   * Send a line of data to the server, and return the handshake.
   */
  String sendline(String data) throws IOException {

    System.out.println("sendline out:" + data);
    ps.println(data);
    ps.flush();

    //
    //  Conversion of the DataInputStream due to deprication.
    //
    // String s = dis.readLine();
    //
    String s = buf_reader.readLine();
    System.out.println("sendline in:" + s);
    return s;
  }


  /**
   * Main routine, for running as a standalone application.
   */
  public static void main(String args[]) {

    CheckMail ap = new CheckMail();
    ap.serverHostName = "localhost";
    ap.standalone = true;

    ClosableJFrame fr = new ClosableJFrame("CheckMail");
    ap.init();
    fr.addComponent("Center", ap);
    fr.setSize(300, 300);
    fr.setVisible(true);
    ap.start();
  }

  public Socket getSocket() {
    return socket;
  }

  public void setSocket(Socket socket) {
    this.socket = socket;
  }

  public String getServerHostName() {
    return serverHostName;
  }

  public void setServerHostName(String serverHostName) {
    this.serverHostName = serverHostName;
  }

  public PrintWriter getPs() {
    return ps;
  }

  public void setPs(PrintWriter ps) {
    this.ps = ps;
  }

  public InetAddress getRina() {
    return rina;
  }

  public void setRina(InetAddress rina) {
    this.rina = rina;
  }

  public InetAddress getLina() {
    return lina;
  }

  public void setLina(InetAddress lina) {
    this.lina = lina;
  }

  public int getPopPort() {
    return popPort;
  }

  public void setPopPort(int popPort) {
    this.popPort = popPort;
  }

  public boolean isStandalone() {
    return standalone;
  }

  public void setStandalone(boolean standalone) {
    this.standalone = standalone;
  }

  public net.mail.swing.CheckMailPanel getForm() {
    return form;
  }

  public void setForm(net.mail.swing.CheckMailPanel form) {
    this.form = form;
  }

  public BufferedReader getBuf_reader() {
    return buf_reader;
  }

  public void setBuf_reader(BufferedReader buf_reader) {
    this.buf_reader = buf_reader;
  }
}


class CheckMailPanel
	extends JPanel implements ActionListener {

  private CheckMail applet;

  // The form's elements...
  private JLabel idLabel;
  private JTextField idField;
  private JLabel pswdLabel;
  private JPasswordField pswdField;
  private JButton button;
  private JLabel resultLabel;
  private JTextField resultField;

 

  /**
   * The constructor.
   */
  public CheckMailPanel(CheckMail ap) {

	applet = ap;
	setBackground(Color.blue);
	setLayout(new GridLayout(7, 1));

	// Instantiate all the elements, and add them to the form...
	add(button = new JButton("Check For Mail"));
	button.addActionListener(this);
	add(idLabel = new JLabel("Id:"));
	add(idField = new JTextField(20));
	add(pswdLabel = new JLabel("Password:"));
	add(pswdField = new JPasswordField(20));
	add(resultLabel = new JLabel("Messages Waiting:"));
	add(resultField = new JTextField(6));
	resultField.setEditable(false);

	// Set the size of the form
	setSize(250, 250);
  }


  /**
   * Return the value of the ID field in the form.
   */
  public String getId() {
	return idField.getText();
  }


  /**
   * Return the value of the password field in the form.
   */
  public String getPswd() {
	return new String(pswdField.getPassword());
  }


  //
  //  Updated to the new Event model.
  //
  public void actionPerformed(ActionEvent e) {

	if (e.getSource() == button) {

	  try {
		applet.checkForMail();
	  } catch (Exception ex) {
		applet.showStatus("Error; unable to check for messages:\n  " + ex.toString());
		return;
	  }
	  applet.showStatus("Completed.");
	}
  }

  public CheckMail getApplet() {
	return applet;
  }

  public void setApplet(CheckMail applet) {
	this.applet = applet;
  }

  public JLabel getIdLabel() {
	return idLabel;
  }

  public void setIdLabel(JLabel idLabel) {
	this.idLabel = idLabel;
  }

  public JTextField getIdField() {
	return idField;
  }

  public void setIdField(JTextField idField) {
	this.idField = idField;
  }

  public JLabel getPswdLabel() {
	return pswdLabel;
  }

  public void setPswdLabel(JLabel pswdLabel) {
	this.pswdLabel = pswdLabel;
  }

  public JPasswordField getPswdField() {
	return pswdField;
  }

  public void setPswdField(JPasswordField pswdField) {
	this.pswdField = pswdField;
  }

  public JButton getButton() {
	return button;
  }

  public void setButton(JButton button) {
	this.button = button;
  }

  public JLabel getResultLabel() {
	return resultLabel;
  }

  public void setResultLabel(JLabel resultLabel) {
	this.resultLabel = resultLabel;
  }

  public JTextField getResultField() {
	return resultField;
  }

  public void setResultField(JTextField resultField) {
	this.resultField = resultField;
  }
}

