package net.RmiSynthesizer;

import classUtils.delegate.DelegateGui;
import classUtils.delegate.DelegateSynthesizer;
import net.rmi.armi.HelloWorld;

import java.util.Date;
import java.util.Vector;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Nov 9, 2004
 * Time: 3:44:23 PM
 */
public class Main {
    DelegateGui dg = new DelegateGui();
    DelegateSynthesizer ds;

    public Main(Vector v) {
        dg.init();
        dg.setInstanceList(v);
        ds = dg.getDelegateSynthesizer();
        ds.setToplogicalSorting(true);
    }

    // for example, see RmiHelloClient
    public String getClient() {
        return "";
    }

    // for example, see RmiHelloServer
    public String getServer() {
        // automate the creation of these parameters by
        // extracting them from
        // the delegate synthesizer
        String packageName = "package net.rmi.armi;\n";
        String serverName = "RmiHelloServer";
        String remoteInterfaceName = "RemoteHelloInterface";
        String remoteInterfaceClassName = "RemoteHelloInterface.class";
        String remoteRegistryName = "RemoteHello";
        return getServer(packageName,
                serverName,
                remoteInterfaceName,
                remoteInterfaceClassName,
                remoteRegistryName);
    }

    private String getServer(String packageName, String serverName, String remoteInterfaceName, String remoteInterfaceClassName, String remoteRegistryName) {
        return packageName +
               "\n" +
               "import net.rmi.utils.RmiRegistryUtils;\n" +
               "import net.rmi.utils.Compile;\n" +
               "\n" +
               "import java.rmi.RemoteException;\n" +
               "import java.rmi.registry.Registry;\n" +
               "\n" +
               "public class " +
                serverName +
                " {\n" +
               "    // before you run this program,\n" +
               "    // you must start the rmiregistry\n" +
               "    // from the classpath root.\n" +
               "    public static void main(String args[]) {\n" +
               "        try {\n" +
               "            startServer();\n" +
               "        } catch (RemoteException e) {\n" +
               "            e.printStackTrace();\n" +
               "        }\n" +
               "    }\n" +
               "\n" +
               "    private static void startServer()\n" +
               "            throws RemoteException {\n" +
               "        println(\"starting server\");\n" +
               "        " +
                remoteInterfaceName +
                " ro = new RemoteHelloImplementation();\n" +
               "        Class c = " +
                remoteInterfaceClassName +
                ";\n" +
               "        Compile.runRmic(c);\n" +
               "        println(\"binding remote instances\");\n" +
               "        // We don't need Naming anymore...\n" +
               "        //Naming.rebind(\"RemoteHello\",ro);\n" +
               "        Registry r = RmiRegistryUtils.getRegistry();\n" +
               "        r.rebind(\"" +
                remoteRegistryName +
                "\", ro);\n" +
               "        println(\"waiting for invocations\");\n" +
               "    }\n" +
               "\n" +
               "    public static void println(Object o) {\n" +
               "        System.out.println(o);\n" +
               "    }\n" +
               "}";
    }

    // for example, see RemoteHelloImplementation
    public String getImplementation() {
        String s = ds.toString();
        return extractImplementation(s);
    }

    private String extractImplementation(String s) {
        int interfaceLocation = s.indexOf("interface");
        String str = "public class";
        int classLocation = s.indexOf(str);
        if (interfaceLocation == -1) {
            System.out.println("interface not found!");
            return null;
        }
        if (classLocation == -1) {
            System.out.println("classLocation not found!");
            return null;
        }
        if (classLocation > interfaceLocation) return
            s.substring(interfaceLocation, classLocation );
        return s.substring(classLocation, interfaceLocation);
    }

    // for example, see RemoteHelloInterface
    public String getInterface() {
        return ds.getInterface();
    }

    public static void main(String[] args) {
        HelloWorld hw = new HelloWorld();
        Vector v = new Vector();
        v.addElement(hw);
        v.addElement(new Date());
        Main m = new Main(v);
        m.print(); // test the output


        // input a class, helloworld, output
        // interface, server, implementation, and a client.
    }

    private void print() {
        System.out.println("The interface is:" + getInterface());
       //System.out.println("The implementation is:" + getImplementation());
       // System.out.println("The server is:" + getServer());
       // System.out.println("The client is:" + getClient());
    }
}
