
package math.numerics;

/**
 * TriggerODE is a wrapper for an ODE that can be used by ODEEventSolvers.
 * It act as a mediator between the ODE and the solver
 * The ODE state array must have fixed length
 * The ODESolver must call getState2 only once
 *
 * @author       Francisco Esquembre (March 2004)
 */
class TriggerODE implements ODE {

  protected ODE ode;
  private int size;
  private double[] odestate;
  private double[] state;

  public TriggerODE (ODE _ode) {
    ode = _ode;
    odestate = ode.getState();
    size = odestate.length;
    state = new double[size];
  }

  public void setState (double[] newstate) {
    System.arraycopy(newstate,0,state,0,size);
  }

  // Interface with the real ODE

  public void readRealState() {
    odestate = ode.getState();
    System.arraycopy(odestate,0,state,0,size);
  }

  public void updateRealState() {
    System.arraycopy(state,0,odestate,0,size);
  }

  // Masking the real ODE

  public double[] getState() { return state; }

  public void getRate(double[] _state, double[] _rate ) {
    ode.getRate(_state,_rate);  // Defer to the real ODE
  }


}

