/*
 * The org.opensourcephysics.numerics package contains numerical methods
 * for the book Simulations in Physics.
 * Copyright (c) 2003  H. Gould, J. Tobochnik, and W. Christian.
 */
package math.numerics;

/**
 * Indicates that an error occured in parser operation, and the operation
 * could not be completed. Used internally in <code>Parser</code> class.
 *
 * @see Parser
 */

public final class ParserException extends Exception {
  private int errorcode;

  /**
   * The constructor of <code>ParserException</code>.
   *
   * @param code the error code
   */

  public ParserException(int code) {
    super();
    errorcode = code;
  }

  public ParserException(String msg) {
    super(msg);
    errorcode = MathExpParser.SYNTAX_ERROR;  // a generic  syntax error
  }

  /**
   * Gets the error code.
   *
   * @return the error code
   */

  public int getErrorCode() {
    return errorcode;
  }
}
