/*
 * The org.opensourcephysics.numerics package contains numerical methods
 * for the book Simulations in Physics.
 * Copyright (c) 2003  H. Gould, J. Tobochnik, and W. Christian.
 */
package math.linearAlgebra;

/**
 * VectorFunction defines a function of multiple variables that returns a resultant vector.
 *
 */
 public interface VectorFunction {
   /**
    * Evaluates the vector function and returns the the result.
    *
    * If the result array is null, a new array is allocated.  Otherwise the result array is used.
    * @param x
    * @param result
    * @return
    */
   public double[] evaluate(double[] x, double[] result);
}