package math.fourierTransforms.r2;

import j2d.ImageUtils;
import j2d.ShortImageBean;
import math.Mat2;

import java.awt.*;

public class FFTShortImageBean {

    ShortImageBean sib;

    public FFTrgb fftRgb = new FFTrgb();

    private short[] imageData_R;
    private short[] imageData_G;
    private short[] imageData_B;


    public FFTShortImageBean(ShortImageBean sib) {
        this.sib = sib;
        initData();
    }

    private void initData() {
        fftRgb.DisplayLogPSD = true;
        init1DArrays();
    }

    private void init1DArrays() {
        if (sib == null)
            System.out.println(
                    "ER:get1DArraysFromParent, sib==null");
        if (sib.getWidth() != sib.getHeight())
            System.out.println("ComplexRgb:transforms.fft Non-square image detected");
        int N = sib.getWidth() * sib.getHeight();
        imageData_R = new short[N];
        imageData_G = new short[N];
        imageData_B = new short[N];

        for (int x = 0; x < sib.getWidth(); x++)
            for (int y = 0; y < sib.getHeight(); y++) {
                imageData_R[x + y * sib.getWidth()] = sib.getR()[x][y];
                imageData_G[x + y * sib.getWidth()] = sib.getG()[x][y];
                imageData_B[x + y * sib.getWidth()] = sib.getB()[x][y];
            }
    }


    public FFTrgb getFFTRgb() {
        return fftRgb;
    }

    public int[] forwardFFT() {
        fftRgb.DisplayLogPSD = true;
        if (sib.getWidth() != sib.getHeight())
            System.out.println("ComplexRgb:transforms.fft ER! Non-square image");
        return fftRgb.forward2dFFT(
                imageData_R,
                imageData_G,
                imageData_B,
                sib.getWidth(),
                sib.getHeight());
    }

    public int[] getPhaseImage() {
        fftRgb.DisplayLogPSD = true;
        if (sib.getWidth() != sib.getHeight())
            System.out.println("ComplexRgb:transforms.fft ER! Non-square image");
        fftRgb.forward2dFFT(
                imageData_R,
                imageData_G,
                imageData_B,
                sib.getWidth(),
                sib.getHeight());
        return fftRgb.getPhaseImage();
    }

    public void complexMultMask(FFTShortImageBean fftShortImageBean) {
        fftRgb.complexMultMask(fftShortImageBean.getFFTRgb());
    }

    public int[] getPsd() {
        return fftRgb.getPsd();
    }

    public Image getPsdImage() {
        return ImageUtils.getImage(fftRgb.getPsd(), sib.getWidth(), sib.getHeight());
    }

    public int[] ifft() {
        return fftRgb.reverse2dFFT();
    }

    /**
     * scale the complex number plane by 1/(w*h);
     * This is key for performing unitary transforms.
     */
    public void normalize() {
        fftRgb.normalize(sib.getWidth(), sib.getHeight());
    }

    public void maskMult(FFTShortImageBean k) {
        fftRgb.maskMult(k.getFFTRgb());
    }

    public void mult(FFTShortImageBean k) {
        fftRgb.mult(k);
    }

    public void scale(float s) {
        fftRgb.scale(s);
    }

    public static void main(String args[]) {

        final int n = 4;
        ShortImageBean sib = new ShortImageBean(n, n);
        sib.setR(Mat2.getIdentity(n, n));
        sib.setG(Mat2.getIdentity(n, n));
        sib.setB(Mat2.getIdentity(n, n));
        sib.print();

        FFTShortImageBean f = new FFTShortImageBean(sib);
        f.forwardFFT();
        f.normalize();
        f.ifft();
        final int[] psd = f.getPsd();
        int psdShort[][] = Mat2.getInt2(psd, n, n);
        Mat2.print(psdShort);
    }
}







