package math.fourierTransforms.r2;

import math.Mat2;
import j2d.ImageUtils;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Nov 16, 2005
 * Time: 2:19:59 PM
 */
public class ComplexFloatImagePlane {
    // These arrays hold the complex image data.
    public float[][] cR_r; // Red real
    public float[][] cG_r; // Green real
    public float[][] cB_r; // Blue real
    public float[][] cR_i; // Red imaginary
    public float[][] cG_i; // Green imaginary
    public float[][] cB_i; // Blue imaginary
    protected int N;
    protected int width;
    protected int height;
    protected float minPSD = 9999999;
    protected float maxPSD = -9999999;

    public void printStats() {
        Mat2.printStats("cR_r", cR_r);
        Mat2.printStats("cG_r", cG_r);
        Mat2.printStats("cB_r", cB_r);
        Mat2.printStats("cR_i", cR_i);
        Mat2.printStats("cG_i", cG_i);
        Mat2.printStats("cB_i", cB_i);

    }

    public void normalize(int w, int h) {
        float sf = 1.0f / (w*h);
        Mat2.scale(cR_r, sf);
        Mat2.scale(cG_r, sf);
        Mat2.scale(cB_r, sf);
        Mat2.scale(cR_i, sf);
        Mat2.scale(cG_i, sf);
        Mat2.scale(cB_i, sf);
    }

    public int[] getPsd() {
        //-------------------------------------------------------------
        // Take PSD on complex RGB values.
        //-------------------------------------------------------------
        // Magnitude of result.
        float[] magnitudeR = magnitudeSpectrum(cR_r, cR_i);
        float[] magnitudeG = magnitudeSpectrum(cG_r, cG_i);
        float[] magnitudeB = magnitudeSpectrum(cB_r, cB_i);

        double scaleFactor; //255.0/Math.log(256);


        System.out.println("Max psd = " + maxPSD);

        scaleFactor = 255.0 / (Math.log(1 + maxPSD));
        //System.out.println("Scalefactor = "+scaleFactor);

        // Adjust 2-D FFT data so that the minimum PSD is
        // based at a value close to a black pixel.

        for (int i = 0; i < N; i++) {
            magnitudeR[i] = (float)
                    (scaleFactor * Math.log(1 + magnitudeR[i]));
            magnitudeG[i] = (float)
                    (scaleFactor * Math.log(1 + magnitudeG[i]));
            magnitudeB[i] = (float)
                    (scaleFactor * Math.log(1 + magnitudeB[i]));
        }

        //System.out.println("Minimum PSD value: " + minPSD);

        // Convert to single ARGB int array and return.
        return ImageUtils.imagetoInt(magnitudeR, magnitudeG, magnitudeB);
    }

    /*
    private float[] copyRealToFloat(float[][] in_r) {
      float[] f_data = new float[N];
      int k = 0;

      for (int i = 0; i < height; i++) {
        for (int j = 0; j < width; j++) {
          f_data[k++] = in_r[i][j];
        }
      }

      return (f_data);
    }
    */
    protected float[] magnitudeSpectrum(float[][] in_r, float[][] in_i) {
        float[] mag = new float[N];
        int k = 0;

        for (int i = 0; i < height; i++) {
            for (int j = 0; j < width; j++) {
                mag[k] = (float) Math.sqrt(in_r[i][j] * in_r[i][j] +
                        in_i[i][j] * in_i[i][j]);

                // Since we're iterating through the loop anyway, see what min is.
                if (minPSD > mag[k])
                    minPSD = mag[k];
                if (maxPSD < mag[k])
                    maxPSD = mag[k];

                k++;
            }
        }

        return (mag);
    }
}
