package math.fourierTransforms.pfa;

import gui.In;
import utils.StopWatch;
import math.complex.ComplexFloat1d;

//Title:        1-d mixed radix Inverse FFT.
//Version:
//Copyright:    Copyright (c) 1998
//Author:       Dongyan Wang
//Company:      University of Wisconsin-Milwaukee.
//Description:
//              According to the definition of the inverse fourier transform,
//              We can use FFT to calculate the IFFT,
//                 IFFT(x) = 1/N * conj(FFT(conj(x)).
//
//              . Change the sign of the imaginary part of the FFT input.
//              . Calculate the FFT.
//              . Change the sign of the imaginary part of the FFT output.
//              . Scale the output by 1/N.
//


public class IPFA1d {
    int N;

    // Constructor: IFFT of Complex data.
    public IPFA1d(int N) {
        this.N = N;
    }

    public void ifft(float inputRe[], float inputIm[]) {

//  Change the sign of the imaginary part of the FFT input.
        for (int i = 0; i < N; i++)
            inputIm[i] = -inputIm[i];

//  Calculate the FFT.
        PFA1d fft1 = new PFA1d(N);
        fft1.fft(inputRe, inputIm);

//  Change the sign of the imaginary part of the FFT output.
//  Scale output by 1/N.

        for (int i = 0; i < inputRe.length; i++) {
            inputRe[i] = inputRe[i] / N;
            inputIm[i] = -inputIm[i] / N;
        }
    }

    public void ifftNoScale(float inputRe[], float inputIm[]) {

//  Change the sign of the imaginary part of the FFT input.
        for (int i = 0; i < N; i++)
            inputIm[i] = -inputIm[i];

//  Calculate the FFT.
        PFA1d fft1 = new PFA1d(N);
        fft1.fft(inputRe, inputIm);

//  Change the sign of the imaginary part of the FFT output.
//  Scale output by 1/N.

        for (int i = 0; i < inputRe.length; i++) {
            inputRe[i] = inputRe[i];
            inputIm[i] = -inputIm[i];
        }
    }

    public static void main(String[] args) {
        do testPfa(In.getInt("select an n > 1"));
                while (In.getBoolean("again?"));
    }

    public static void testPfa(int n) {
        float re[] = new float[n];
        float im[] = new float[n];
        for (int i = 0; i < im.length; i++) {
            re[i] = i;
        }
        PFA1d fft1 = new PFA1d(re.length);
        IPFA1d ifft1 = new IPFA1d(re.length);
        StopWatch t = new StopWatch();
        t.start();
        fft1.fft(re, im);
        t.stop();
        System.out.println("time for forward PFA n=" + n);
        t.report();
        t.start();
        ifft1.ifft(re, im);
        System.out.println("time for backward PFA n=" + n);
        t.report();
        //print(re);
    }

    public static void print(float f[]) {
        for (int i = 0; i < f.length; i++)
            System.out.println(f[i]);
    }

    public void ifft(float[] floats, float[] floats1, boolean scale) {
        if (scale) ifft(floats,floats1);
        else ifftNoScale(floats,floats1);
    }

    public void ifft(ComplexFloat1d c) {
        ifft(c.getRe(),c.getIm(),false);
    }
}
