package math.fourierTransforms;

import utils.StopWatch;
import math.fourierTransforms.pfa.IPFA1d;
import math.fourierTransforms.r2.FFTR2Double;
import math.Mat1;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Oct 31, 2005
 * Time: 1:20:57 PM
 */
public class DFTTest {
    public static void timeFFT(int n) {
        FFTR2Double f = new FFTR2Double(n);
        DFT dft = new DFT(n);

        double x1[] = new double[n];
        for (int j = 0; j < n; j++)
            x1[j] = j;


        double[] in_r;
        double[] in_i = new double[n];

        // copy test signal.
        in_r = Mat1.arrayCopy(x1);
        StopWatch t = new StopWatch();
        t.start();
        f.forwardFFT(in_r, in_i);
        t.stop();

        System.out.print("Time for " + n + "point fft");
        t.report();

        // Copy to new array because IFFT will
        // destroy the FFT results.
        Mat1.arrayCopy(in_r);
        Mat1.arrayCopy(in_i);

        t.clear();
        t.start();
        f.reverseFFT(in_r, in_i);
        t.stop();
        System.out.print("Time for " + n + "point ifft");
        t.report();
        t.clear();
        t.start();
        dft.dft(in_r);
        t.stop();
        System.out.print("Time for " + n + "point FFTR2Double");
        t.report();
        t.start();
        dft.idft();
        t.stop();
        System.out.println("Time for " + n + " point IDFT");
        t.report();
        IPFA1d.testPfa(n);
    }

    public static double getTimeDFT(int n) {
        DFT f = new DFT(n);


        double x1[] = new double[n];
        for (int j = 0; j < n; j++)
            x1[j] = j;

        // copy test signal.
        double[] in_r = Mat1.arrayCopy(x1);
        StopWatch t = new StopWatch();
        t.start();
        f.dft(in_r);
        f.idft();
        t.stop();
        return t.getTimeInMs();
    }
}
