package math.fourierTransforms;

import math.Mat1;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Oct 31, 2005
 * Time: 1:26:24 PM
 * Totally self-contained DFT example.
 * This is an O(N**2) algorithm that works for any value of N.
 */
public class DFT {

    private double r_data[] = null;
    private double i_data[] = null;

    public DFT(int N) {
        r_data = new double[N];
        i_data = new double[N];
    }

    private void normalizeData() {
        int N = r_data.length;
        for (int k = 0; k < N; k++) {
            r_data[k] /= N;
            i_data[k] /= N;
        }

    }

    /**
     * Do a FFTR2Double via direct methods. This is
     * an O(N**2) time algorithm.
     *
     * @param inputData input real numbers.
     * @return PSD
     */
    public double[] dft(double inputData[]) {
        int N = inputData.length;
        double twoPikOnN;
        double twoPijkOnN;


        double twoPiOnN = 2 * Math.PI / N;

        r_data = new double[N];
        i_data = new double[N];

        for (int k = 0; k < N; k++) {
            twoPikOnN = twoPiOnN * k;
            for (int j = 0; j < N; j++) {
                twoPijkOnN = twoPikOnN * j;
                //System.out.println("twoPijkOnN=" + twoPijkOnN);
                r_data[k] += inputData[j] * Math.cos(twoPijkOnN);
                i_data[k] -= inputData[j] * Math.sin(twoPijkOnN);
            }
        }
        normalizeData();
        return (getPowerSpectralDensity());
    }

    public double[] getPowerSpectralDensity() {
        double[] psd = new double[r_data.length];
        for (int k = 0; k < r_data.length; k++) {
            psd[k] =
                    r_data[k] * r_data[k] +
                            i_data[k] * i_data[k];

        }
        return psd;
    }

    // assume that r_data and i_data are
    // set. Also assume that the real
    // value is to be returned
    public double[] idft() {
        int N = r_data.length;
        double twoPiOnN = 2 * Math.PI / N;

        double twoPikOnN;
        double twoPijkOnN;

        double v[] = new double[N];


        for (int k = 0; k < N; k++) {
            twoPikOnN = twoPiOnN * k;
            for (int j = 0; j < N; j++) {
                twoPijkOnN = twoPikOnN * j;
                v[k] += r_data[j] * Math.cos(twoPijkOnN)
                        - i_data[j] * Math.sin(twoPijkOnN);

            }
        }
        return (v);
    }

    /**
     * Test the DFT using a small number of samples.
     * This is an <i>O(N**2)</i> algorithm.
     */
    public static void testDFT() {
        int N = 8;
        DFT f = new DFT(N);

        double x1[] = Mat1.getRampData(N);
        // take dft
        f.dft(x1);

        double psd[] = f.idft();
        System.out.println("j\tx1[j]\tre[j]\tim[j]\t psd[j]");
        for (int j = 0; j < N; j++)
            System.out.println(j + "\t" +
                    x1[j] + "\t" +
                    f.r_data[j] + "\t" +
                    f.i_data[j] + "\t" +
                    psd[j]);
    }

    public static void main(String args[]) {
        //Oscillator.testAudioDft();  // this works!
        testDFT();
        //timeFFT();

    }
}
