/*
 * Copyright (c) 2005 Your Corporation. All Rights Reserved.
 */
package math.complex;

import math.Mat2;

/**
 * User: lyon
 * Date: Nov 13, 2005
 * Time: 8:00:08 AM
 * Copyright DocJava, Inc. 2005.
 */
public class ComplexFloat2d {
    private float re[][];
    private float im[][];

    public ComplexFloat2d() {
    }

    public ComplexFloat2d(int w, int h) {
        re = new float[w][h];
        im = new float[w][h];
    }

    public ComplexFloat2d(float re[][], float im[][]) {
        this.re = re;
        this.im = im;
    }

    public void scale(float sc) {
        for (int x = 0; x < re.length; x++) {
            for (int y = 0; y < re[0].length; y++) {
                re[x][y] *= sc;
            }
        }
        for (int x = 0; x < re.length; x++) {
            for (int y = 0; y < re[0].length; y++) {
                im[x][y] *= sc;
            }
        }
    }
    // (x1+iy1)*(x2*iy2)=
    // x1x2-y1y2
    // i(x2y1+x1y2)
    public void mult(ComplexFloat2d b) {
        for (int x = 0; x < re.length; x++) {
            for (int y = 0; y < re[0].length; y++) {
                final float x1 = re[x][y];
                final float y1 = im[x][y];
                final float x2 = b.getRe(x, y);
                final float y2 = b.getIm(x, y);
                re[x][y] = x1 * x2 - y1 * y2;
                im[x][y] = y1 * x2 + x1 * y2;
            }
        }
    }

    public void plus(ComplexFloat2d b) {
        for (int x = 0; x < re.length; x++) {
            for (int y = 0; y < re[0].length; y++) {
                re[x][y] += b.getRe(x, y);
            }
        }
        for (int x = 0; x < re.length; x++) {
            for (int y = 0; y < re[0].length; y++) {
                im[x][y] += b.getIm(x, y);
            }
        }
    }

    public void minus(ComplexFloat2d b) {
        for (int x = 0; x < re.length; x++) {
            for (int y = 0; y < re[0].length; y++) {
                re[x][y] -= b.getRe(x, y);
            }
        }
        for (int x = 0; x < re.length; x++) {
            for (int y = 0; y < re[0].length; y++) {
                im[x][y] -= b.getIm(x, y);
            }
        }
    }

    //re[i] -= b.getRe(i)
    public float[][] getIm() {
        return im;
    }

    public float getIm(int x, int y) {
        return im[x][y];
    }

    public void setIm(float im[][]) {
        this.im = im;
    }

    public float getRe(int x, int y) {
        return re[x][y];
    }

    public float[][] getRe() {
        return re;
    }

    public int getLength() {
        return re.length;
    }

    public void setRe(float re[][]) {
        this.re = re;
    }

    public void printStats(String s) {
        Mat2.printStats(s,re);
        Mat2.printStats(s,im);
    }


}
