package math.complex;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * ComplexSinglePrecisionArray Tester.
 *
 * @author D. Lyon
 * @version 1.0
 * @since <pre>11/13/2005</pre>
 */
public class ComplexFloat1dTest extends TestCase {
    private ComplexFloat1d c = new ComplexFloat1d(10);

    public ComplexFloat1dTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        init();
    }

    private void init() {
        float re[] = c.getRe();
        float im[] = c.getIm();
        for (int i = 0; i < 10; i++) {
            re[i] = i;
            im[i] = i;
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPlus() throws Exception {
        init();
        c.plus(c);
        float re[] = c.getRe();
        float im[] = c.getIm();
        int n = im.length;
        assertEquals((short) re[0], (short) im[0]);
        float v = re[n - 1];
        assertEquals((short) ((n - 1) * 2), (short) v);
    }

    public void testGetCopy() throws Exception {
        //TODO: Test goes here...
    }

    public void testScaleAndMask() throws Exception {
        //TODO: Test goes here...
    }

    public void testTimes() throws Exception {
        float re[] = c.getRe();
        float im[] = c.getIm();
        for (int i = 0; i < 10; i++) {
            re[i] = i;
            im[i] = i;
        }
        c.mult(c);
        int n = im.length;
        for (int i=0; i < n; i++){
           assertEquals((short)re[i],0);
        }
    }

    public void testMinus() throws Exception {
        init();
        c.minus(c);
        float re[] = c.getRe();
        float im[] = c.getIm();
        int n = im.length;
        assertEquals((short) re[0], (short) re[0]);
        float v = re[n - 1];
        assertEquals(0, (short) v);
    }

    public void testLogScaleMagnitude() throws Exception {
        //TODO: Test goes here...
    }

    public void testGetIm() throws Exception {
        //TODO: Test goes here...
    }

    public void testSetIm() throws Exception {
        //TODO: Test goes here...
    }

    public void testGetRe() throws Exception {
        //TODO: Test goes here...
    }

    public void testGetRe1() throws Exception {
        //TODO: Test goes here...
    }

    public void testGetLength() throws Exception {
        //TODO: Test goes here...
    }

    public void testSetRe() throws Exception {
        //TODO: Test goes here...
    }

    public static Test suite() {
        return new TestSuite(ComplexFloat1dTest.class);
    }
}
