package math.complex;

public class ComplexDouble {
  private double real;
  private double imaginary;

  public ComplexDouble(double _x, double _y) {
    real = _x;
    imaginary = _y;
  }

  public ComplexDouble() {
    real = 0;
    imaginary = 0;
  }

  public void set(double _x, double _y) {
    real = _x;
    imaginary = _y;
  }

  public void setReal(double _x) {
    real = _x;
  }

  public void setImaginary(double _i) {
    imaginary = _i;
  }

  public void addReal(double _x) {
    real += _x;
  }

  public void addImaginary(double _i) {
    imaginary += _i;
  }

  public double getReal() {
    return real;
  }

  public double getImaginary() {
    return imaginary;
  }

  // c = a + b, c=a.plus(b)
  public ComplexDouble plus(ComplexDouble b) {
    return new ComplexDouble(
        b.real + real,
        b.imaginary + imaginary);
  }

  // c = a - b, c=a.minus(b);
  public ComplexDouble minus(ComplexDouble b) {
    return new ComplexDouble(
        real - b.real,
        imaginary - b.imaginary);
  }

  // c = a * b, c=a.times(b);
  //(x1 + iy1)(x2 + iy2) =
  //      x1        *  x2    - y1        * y2 +
  //    i(y1        *  x2    + x1        * y2)
  public ComplexDouble times(ComplexDouble b) {
    return new ComplexDouble(
        real * b.real - imaginary * b.imaginary,
        imaginary * b.real + real * b.imaginary);
  }

  // c = a.abs()
  public ComplexDouble abs() {
    return new ComplexDouble(
        Math.abs(real),
        Math.abs(imaginary)
    );
  }

  // c = 1/a, c=inverse(a);
  public ComplexDouble inverse() {
    double m = square();
    return new ComplexDouble(
        real / m,
        -imaginary / m
    );
  }

  // c = a^2, c = a.square();
  public double square() {
    return real * real + imaginary * imaginary;
  }

  // c = |a|, c=a.magnitude()
  public double magnitude() {
    return Math.sqrt(square());
  }

  // makes a copy of this
  // c = a.copy();
  public ComplexDouble copy() {
    return new ComplexDouble(real, imaginary);
  }

  public void print() {
    System.out.println("Complex: real = " + real + " Imaginary = " + imaginary);
  }

  public void print(String msg) {
    System.out.println(msg + "(" + real + "," + imaginary + ")");
  }
}