/*
 * Copyright (c) 2005 DocJava, Inc.
 All Rights Reserved.
 */
package math;

public class Vec3Float {
    private float x;
    private float y;
    private float z;

    public Vec3Float() {
    }

    public Vec3Float(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static float length(Vec3Float v) {
        return (float) Math.sqrt(
                v.x * v.x + v.y * v.y +
                v.z * v.z);
    }

    public static Vec3Float normalize(Vec3Float v) {
        float length = length(v);
        return new Vec3Float(v.x / length,
                                v.y / length,
                                v.z / length);
    }

    public static Vec3Float vectordist(
            Vec3Float v1, Vec3Float v2) {
        return new Vec3Float(v1.x - v2.x,
                                v1.y - v2.y,
                                v1.z - v2.z);
    }

    public static Vec3Float getNormal(Vec3Float a,
                                  Vec3Float b,
                                  Vec3Float c) {
        Vec3Float n = new Vec3Float();
        float ax = b.x - a.x;
        float ay = b.y - a.y;
        float az = b.z - a.z;
        float bx = c.x - a.x;
        float by = c.y - a.y;
        float bz = c.z - a.z;
        n.x = ay * bz - by * az;
        n.y = az * bx - bz * ax;
        n.z = ax * by - bx * ay;
        return normalize(n);
    }

    public float getX() {
        return x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getZ() {
        return z;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public static Vec3Float matrixvectorproduct(
            Mat4f b, Vec3Float a) {
        Vec3Float c = new Vec3Float();
        c.setX(a.getX() * b.getMatrix()[0][0] +
              a.getY() * b.getMatrix()[0][1] +
              a.getZ() * b.getMatrix()[0][2] +
              b.getMatrix()[0][3]);
        c.setY(a.getX() * b.getMatrix()[1][0] +
              a.getY() * b.getMatrix()[1][1] +
              a.getZ() * b.getMatrix()[1][2] +
              b.getMatrix()[1][3]);
        c.setZ(a.getX() * b.getMatrix()[2][0] +
              a.getY() * b.getMatrix()[2][1] +
              a.getZ() * b.getMatrix()[2][2] +
              b.getMatrix()[2][3]);
        return c;
    }
}
