package math;

import javax.crypto.KeyGenerator;
import java.awt.*;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 24, 2004
 * <p/>
 * Time: 6:25:08 PM
 */
public class Random {
    public static int getRandom() {
        return (int) ((Math.random() * 100) + 1);
    }

    /*
    Here is what I wrote in PASCAL a long time ago...
    function lcg: integer;
    const
    a = 1103515245;
    c = 12345;
    begin
    seed := a * seed + c;
    lcg := round(seed div 65536 mod 32768);
    end; {lcg}

    */
    public static int lcg(int seed) {
        final int a = 1103515245;
        final int c = 12345;
        seed = a * seed + c;
        return (seed / 65536) % 32768;
    }

    public static void lcgTest() {
        int seed = 20;
        for (int i = 0; i < 100; i++) {
            seed = lcg(seed);
            System.out.print(seed + " ");
            if (i % 20 == 0) System.out.println();
        }
    }

    public static void hashCodeTest() {
        String s = "lyonfoo";
        System.out.println(s.hashCode());
        String s1 = "lyonfoo";
        System.out.println(s1.hashCode());
        String s2 = "lyonfoo";
        System.out.println(s2.hashCode());
        System.out.println("foolyon".hashCode());

    }

    public static void jceKeyTest() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("DES");
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed("lyonfoo".hashCode());
        generator.init(secureRandom);
        Key key = generator.generateKey();
        byte b[] = key.getEncoded();
        System.out.println(b.length+" bytes:");
        for (int i=0; i < b.length; i++)
            System.out.println((0xff&b[i]));
        System.out.println();

    }

    public static void jceRandomNumberTest() {
        SecureRandom r = new SecureRandom();
        String uidPw = "lyonfoo";

        r.setSeed(uidPw.hashCode());
        for (int i = 0; i < 100; i++) {
            System.out.print(r.nextInt() + " ");
            if (i % 20 == 0) System.out.println();
        }

    }

    public static void main(String[] args) {
        try {
            jceKeyTest();
            System.out.println("------");
            jceKeyTest();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
    }

    public static void randTest() {
        for (int i = 0; i < 100; i++) {
            System.out.print(rand(1, 10) + " ");
            if (i % 20 == 0) System.out.println();
        }
    }

    /**
     * Compute a random integer
     *
     * @param min minimum int
     * @param max maximum int
     * @return random int between <code>min</code> and <code>max</code>
     *         inclusive.
     */
    public static int rand(int min, int max) {
        return (int) (Math.round(Math.random() * (max - min) + min));
    }

    public static Color getRandomColor() {
        return new Color(rand(0, 255), rand(0, 255), rand(0, 255));
    }
}
